/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import java.util.Collections;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.jackson.ContextDataAsEntryListDeserializer;
import org.apache.logging.log4j.core.jackson.ContextDataAsEntryListSerializer;
import org.apache.logging.log4j.core.jackson.ContextDataDeserializer;
import org.apache.logging.log4j.core.jackson.ContextDataSerializer;
import org.apache.logging.log4j.core.jackson.ExtendedStackTraceElementMixIn;
import org.apache.logging.log4j.core.jackson.InstantMixIn;
import org.apache.logging.log4j.core.jackson.LevelMixIn;
import org.apache.logging.log4j.core.jackson.Log4jStackTraceElementDeserializer;
import org.apache.logging.log4j.core.jackson.LogEventMixIn;
import org.apache.logging.log4j.core.jackson.MarkerMixIn;
import org.apache.logging.log4j.core.jackson.MessageSerializer;
import org.apache.logging.log4j.core.jackson.MutableThreadContextStackDeserializer;
import org.apache.logging.log4j.core.jackson.ObjectMessageSerializer;
import org.apache.logging.log4j.core.jackson.StackTraceElementMixIn;
import org.apache.logging.log4j.core.jackson.ThrowableProxyMixIn;
import org.apache.logging.log4j.core.jackson.ThrowableProxyWithStacktraceAsStringMixIn;
import org.apache.logging.log4j.core.jackson.ThrowableProxyWithoutStacktraceMixIn;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.Module;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.module.SimpleDeserializers;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.module.SimpleSerializers;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.util.StringMap;

class Initializers {
    Initializers() {
    }

    static class SimpleModuleInitializer {
        SimpleModuleInitializer() {
        }

        void initialize(SimpleModule simpleModule, boolean objectMessageAsJsonObject) {
            simpleModule.addDeserializer(StackTraceElement.class, new Log4jStackTraceElementDeserializer());
            simpleModule.addDeserializer(ThreadContext.ContextStack.class, new MutableThreadContextStackDeserializer());
            if (objectMessageAsJsonObject) {
                simpleModule.addSerializer(ObjectMessage.class, new ObjectMessageSerializer());
            }
            simpleModule.addSerializer(Message.class, new MessageSerializer());
        }
    }

    static class SetupContextInitializer
    extends AbstractInitializer {
        SetupContextInitializer() {
        }

        @Override
        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            super.setupModule(context, includeStacktrace, stacktraceAsString);
            context.addSerializers(new SimpleSerializers(Collections.singletonList(new ContextDataSerializer())));
            context.addDeserializers(new SimpleDeserializers(Collections.singletonMap(StringMap.class, new ContextDataDeserializer())));
        }
    }

    static class SetupContextAsEntryListInitializer
    extends AbstractInitializer {
        SetupContextAsEntryListInitializer() {
        }

        @Override
        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            super.setupModule(context, includeStacktrace, stacktraceAsString);
            context.addSerializers(new SimpleSerializers(Collections.singletonList(new ContextDataAsEntryListSerializer())));
            context.addDeserializers(new SimpleDeserializers(Collections.singletonMap(StringMap.class, new ContextDataAsEntryListDeserializer())));
        }
    }

    private static abstract class AbstractInitializer {
        private AbstractInitializer() {
        }

        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            context.setMixInAnnotations(StackTraceElement.class, StackTraceElementMixIn.class);
            context.setMixInAnnotations(Marker.class, MarkerMixIn.class);
            context.setMixInAnnotations(Level.class, LevelMixIn.class);
            context.setMixInAnnotations(Instant.class, InstantMixIn.class);
            context.setMixInAnnotations(LogEvent.class, LogEventMixIn.class);
            context.setMixInAnnotations(ExtendedStackTraceElement.class, ExtendedStackTraceElementMixIn.class);
            context.setMixInAnnotations(ThrowableProxy.class, includeStacktrace ? (stacktraceAsString ? ThrowableProxyWithStacktraceAsStringMixIn.class : ThrowableProxyMixIn.class) : ThrowableProxyWithoutStacktraceMixIn.class);
        }
    }
}

