/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.annotation;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.annotation.JacksonAnnotation;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.annotation.PropertyAccessor;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonAutoDetect {
    public Visibility getterVisibility() default Visibility.DEFAULT;

    public Visibility isGetterVisibility() default Visibility.DEFAULT;

    public Visibility setterVisibility() default Visibility.DEFAULT;

    public Visibility creatorVisibility() default Visibility.DEFAULT;

    public Visibility scalarConstructorVisibility() default Visibility.DEFAULT;

    public Visibility fieldVisibility() default Visibility.DEFAULT;

    public static class Value
    implements JacksonAnnotationValue<JsonAutoDetect>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Visibility DEFAULT_FIELD_VISIBILITY = Visibility.PUBLIC_ONLY;
        protected static final Value DEFAULT = new Value(DEFAULT_FIELD_VISIBILITY, Visibility.PUBLIC_ONLY, Visibility.PUBLIC_ONLY, Visibility.ANY, Visibility.PUBLIC_ONLY, Visibility.NON_PRIVATE);
        protected static final Value NO_OVERRIDES = new Value(Visibility.DEFAULT, Visibility.DEFAULT, Visibility.DEFAULT, Visibility.DEFAULT, Visibility.DEFAULT, Visibility.DEFAULT);
        protected final Visibility _fieldVisibility;
        protected final Visibility _getterVisibility;
        protected final Visibility _isGetterVisibility;
        protected final Visibility _setterVisibility;
        protected final Visibility _creatorVisibility;
        protected final Visibility _scalarConstructorVisibility;

        private Value(Visibility fields, Visibility getters, Visibility isGetters, Visibility setters, Visibility creators, Visibility scalarCtors) {
            this._fieldVisibility = fields;
            this._getterVisibility = getters;
            this._isGetterVisibility = isGetters;
            this._setterVisibility = setters;
            this._creatorVisibility = creators;
            this._scalarConstructorVisibility = scalarCtors;
        }

        public static Value defaultVisibility() {
            return DEFAULT;
        }

        public static Value noOverrides() {
            return NO_OVERRIDES;
        }

        public static Value from(JsonAutoDetect src) {
            return Value.construct(src.fieldVisibility(), src.getterVisibility(), src.isGetterVisibility(), src.setterVisibility(), src.creatorVisibility(), src.scalarConstructorVisibility());
        }

        public static Value construct(PropertyAccessor acc, Visibility visibility) {
            Visibility fields = Visibility.DEFAULT;
            Visibility getters = Visibility.DEFAULT;
            Visibility isGetters = Visibility.DEFAULT;
            Visibility setters = Visibility.DEFAULT;
            Visibility creators = Visibility.DEFAULT;
            Visibility scalarCtors = Visibility.DEFAULT;
            switch (acc) {
                case FIELD: {
                    fields = visibility;
                    break;
                }
                case GETTER: {
                    getters = visibility;
                    break;
                }
                case IS_GETTER: {
                    isGetters = visibility;
                    break;
                }
                case SETTER: {
                    setters = visibility;
                    break;
                }
                case CREATOR: {
                    creators = visibility;
                    break;
                }
                case SCALAR_CONSTRUCTOR: {
                    scalarCtors = visibility;
                    break;
                }
                case NONE: {
                    break;
                }
                case ALL: {
                    creators = scalarCtors = visibility;
                    setters = scalarCtors;
                    isGetters = scalarCtors;
                    getters = scalarCtors;
                    fields = scalarCtors;
                }
            }
            return Value.construct(fields, getters, isGetters, setters, creators, scalarCtors);
        }

        @Deprecated
        public static Value construct(Visibility fields, Visibility getters, Visibility isGetters, Visibility setters, Visibility creators) {
            return Value.construct(fields, getters, isGetters, setters, creators, Visibility.DEFAULT);
        }

        public static Value construct(Visibility fields, Visibility getters, Visibility isGetters, Visibility setters, Visibility creators, Visibility scalarCtors) {
            Value v = Value._predefined(fields, getters, isGetters, setters, creators, scalarCtors);
            if (v == null) {
                v = new Value(fields, getters, isGetters, setters, creators, scalarCtors);
            }
            return v;
        }

        public Value withFieldVisibility(Visibility v) {
            return Value.construct(v, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility, this._scalarConstructorVisibility);
        }

        public Value withGetterVisibility(Visibility v) {
            return Value.construct(this._fieldVisibility, v, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility, this._scalarConstructorVisibility);
        }

        public Value withIsGetterVisibility(Visibility v) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, v, this._setterVisibility, this._creatorVisibility, this._scalarConstructorVisibility);
        }

        public Value withSetterVisibility(Visibility v) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, v, this._creatorVisibility, this._scalarConstructorVisibility);
        }

        public Value withCreatorVisibility(Visibility v) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, v, this._scalarConstructorVisibility);
        }

        public Value withScalarConstructorVisibility(Visibility v) {
            return Value.construct(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility, v);
        }

        public static Value merge(Value base, Value overrides) {
            return base == null ? overrides : base.withOverrides(overrides);
        }

        public Value withOverrides(Value overrides) {
            Visibility scalarCtors;
            Visibility creators;
            Visibility setters;
            Visibility isGetters;
            Visibility getters;
            if (overrides == null || overrides == NO_OVERRIDES || overrides == this) {
                return this;
            }
            Visibility fields = Value._override(this._fieldVisibility, overrides._fieldVisibility);
            if (Value._equals(this, fields, getters = Value._override(this._getterVisibility, overrides._getterVisibility), isGetters = Value._override(this._isGetterVisibility, overrides._isGetterVisibility), setters = Value._override(this._setterVisibility, overrides._setterVisibility), creators = Value._override(this._creatorVisibility, overrides._creatorVisibility), scalarCtors = Value._override(this._scalarConstructorVisibility, overrides._scalarConstructorVisibility))) {
                return this;
            }
            return Value.construct(fields, getters, isGetters, setters, creators, scalarCtors);
        }

        private static Visibility _override(Visibility base, Visibility override) {
            return override == Visibility.DEFAULT ? base : override;
        }

        @Override
        public Class<JsonAutoDetect> valueFor() {
            return JsonAutoDetect.class;
        }

        public Visibility getFieldVisibility() {
            return this._fieldVisibility;
        }

        public Visibility getGetterVisibility() {
            return this._getterVisibility;
        }

        public Visibility getIsGetterVisibility() {
            return this._isGetterVisibility;
        }

        public Visibility getSetterVisibility() {
            return this._setterVisibility;
        }

        public Visibility getCreatorVisibility() {
            return this._creatorVisibility;
        }

        public Visibility getScalarConstructorVisibility() {
            return this._scalarConstructorVisibility;
        }

        protected Object readResolve() {
            Value v = Value._predefined(this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility, this._scalarConstructorVisibility);
            return v == null ? this : v;
        }

        public String toString() {
            return String.format("JsonAutoDetect.Value(fields=%s,getters=%s,isGetters=%s,setters=%s,creators=%s,scalarConstructors=%s)", new Object[]{this._fieldVisibility, this._getterVisibility, this._isGetterVisibility, this._setterVisibility, this._creatorVisibility, this._scalarConstructorVisibility});
        }

        public int hashCode() {
            return 1 + this._fieldVisibility.ordinal() ^ 3 * this._getterVisibility.ordinal() - 7 * this._isGetterVisibility.ordinal() + 11 * this._setterVisibility.ordinal() ^ 13 * this._creatorVisibility.ordinal() + 17 * this._scalarConstructorVisibility.ordinal();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Value v = (Value)o;
            return Value._equals(this, v._fieldVisibility, v._getterVisibility, v._isGetterVisibility, v._setterVisibility, v._creatorVisibility, v._scalarConstructorVisibility);
        }

        private static Value _predefined(Visibility fields, Visibility getters, Visibility isGetters, Visibility setters, Visibility creators, Visibility scalarCtors) {
            if (fields == DEFAULT_FIELD_VISIBILITY) {
                if (getters == Value.DEFAULT._getterVisibility && isGetters == Value.DEFAULT._isGetterVisibility && setters == Value.DEFAULT._setterVisibility && creators == Value.DEFAULT._creatorVisibility && scalarCtors == Value.DEFAULT._scalarConstructorVisibility) {
                    return DEFAULT;
                }
            } else if (fields == Visibility.DEFAULT && getters == Visibility.DEFAULT && isGetters == Visibility.DEFAULT && setters == Visibility.DEFAULT && creators == Visibility.DEFAULT && scalarCtors == Visibility.DEFAULT) {
                return NO_OVERRIDES;
            }
            return null;
        }

        private static boolean _equals(Value v, Visibility fields, Visibility getters, Visibility isGetters, Visibility setters, Visibility creators, Visibility scalarCtors) {
            return v._fieldVisibility == fields && v._getterVisibility == getters && v._isGetterVisibility == isGetters && v._setterVisibility == setters && v._creatorVisibility == creators && v._scalarConstructorVisibility == scalarCtors;
        }
    }

    public static enum Visibility {
        ANY,
        NON_PRIVATE,
        PROTECTED_AND_PUBLIC,
        PUBLIC_ONLY,
        NONE,
        DEFAULT;


        public boolean isVisible(Member m) {
            switch (this) {
                case ANY: {
                    return true;
                }
                case NONE: {
                    return false;
                }
                case NON_PRIVATE: {
                    return !Modifier.isPrivate(m.getModifiers());
                }
                case PROTECTED_AND_PUBLIC: {
                    if (Modifier.isProtected(m.getModifiers())) {
                        return true;
                    }
                }
                case PUBLIC_ONLY: {
                    return Modifier.isPublic(m.getModifiers());
                }
            }
            return false;
        }
    }
}

