/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.JavaType;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.JsonNode;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.util.ClassUtil;
import org.apache.logging.log4j.internal_do_not_import_491952.com.fasterxml.jackson.databind.util.Converter;

public class StdDelegatingSerializer
extends StdSerializer<Object>
implements ContextualSerializer,
ResolvableSerializer,
JsonFormatVisitable {
    protected final Converter<Object, ?> _converter;
    protected final JavaType _delegateType;
    protected final JsonSerializer<Object> _delegateSerializer;

    public StdDelegatingSerializer(Converter<?, ?> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public <T> StdDelegatingSerializer(Class<T> cls, Converter<T, ?> converter) {
        super(cls, false);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public StdDelegatingSerializer(Converter<Object, ?> converter, JavaType delegateType, JsonSerializer<?> delegateSerializer) {
        super(delegateType);
        this._converter = converter;
        this._delegateType = delegateType;
        this._delegateSerializer = delegateSerializer;
    }

    protected StdDelegatingSerializer withDelegate(Converter<Object, ?> converter, JavaType delegateType, JsonSerializer<?> delegateSerializer) {
        ClassUtil.verifyMustOverride(StdDelegatingSerializer.class, this, "withDelegate");
        return new StdDelegatingSerializer(converter, delegateType, delegateSerializer);
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._delegateSerializer != null && this._delegateSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)this._delegateSerializer)).resolve(provider);
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> delSer = this._delegateSerializer;
        JavaType delegateType = this._delegateType;
        if (delSer == null) {
            if (delegateType == null) {
                delegateType = this._converter.getOutputType(provider.getTypeFactory());
            }
            if (!delegateType.isJavaLangObject()) {
                delSer = provider.findValueSerializer(delegateType);
            }
        }
        if (delSer instanceof ContextualSerializer) {
            delSer = provider.handleSecondaryContextualization(delSer, property);
        }
        if (delSer == this._delegateSerializer && delegateType == this._delegateType) {
            return this;
        }
        return this.withDelegate(this._converter, delegateType, delSer);
    }

    protected Converter<Object, ?> getConverter() {
        return this._converter;
    }

    @Override
    public JsonSerializer<?> getDelegatee() {
        return this._delegateSerializer;
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        Object delegateValue = this.convertValue(ctxt, value);
        if (delegateValue == null) {
            ctxt.defaultSerializeNull(gen);
            return;
        }
        JsonSerializer<Object> ser = this._delegateSerializer;
        if (ser == null) {
            ser = this._findSerializer(delegateValue, ctxt);
        }
        ser.serialize(delegateValue, gen, ctxt);
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        Object delegateValue = this.convertValue(ctxt, value);
        if (delegateValue == null) {
            ctxt.defaultSerializeNull(gen);
            return;
        }
        JsonSerializer<Object> ser = this._delegateSerializer;
        if (ser == null) {
            ser = this._findSerializer(delegateValue, ctxt);
        }
        ser.serializeWithType(delegateValue, gen, ctxt, typeSer);
    }

    @Override
    public boolean isEmpty(SerializerProvider ctxt, Object value) {
        Object delegateValue = this.convertValue(ctxt, value);
        if (delegateValue == null) {
            return true;
        }
        if (this._delegateSerializer == null) {
            return value == null;
        }
        return this._delegateSerializer.isEmpty(ctxt, delegateValue);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        if (this._delegateSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._delegateSerializer)).getSchema(provider, typeHint);
        }
        return super.getSchema(provider, typeHint);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint, boolean isOptional) throws JsonMappingException {
        if (this._delegateSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._delegateSerializer)).getSchema(provider, typeHint, isOptional);
        }
        return super.getSchema(provider, typeHint);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (this._delegateSerializer != null) {
            this._delegateSerializer.acceptJsonFormatVisitor(visitor, typeHint);
        }
    }

    @Deprecated
    protected Object convertValue(Object value) {
        return this._converter.convert(value);
    }

    protected Object convertValue(SerializerProvider ctxt, Object value) {
        return this._converter.convert(ctxt, value);
    }

    protected JsonSerializer<Object> _findSerializer(Object value, SerializerProvider serializers) throws JsonMappingException {
        JsonSerializer<Object> ser = serializers.findValueSerializer(value.getClass());
        if (ser instanceof ContextualSerializer) {
            ser = ((ContextualSerializer)((Object)ser)).createContextual(serializers, null);
        }
        return ser;
    }
}

