/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.error.QueryResultException;
import com.amazon.athena.client.results.AsyncQueryResults;
import com.amazon.athena.client.results.AsyncQueryResultsFactory;
import com.amazon.athena.client.results.GetQueryResultsQueryResults;
import com.amazon.athena.client.results.ResultPage;
import com.amazon.athena.client.results.ResultParserFactory;
import com.amazon.athena.client.results.parsing.GetQueryResultsParser;
import com.amazon.athena.logging.AthenaLogger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.QueryExecution;

public class GetQueryResultsQueryResultsFactory
implements AsyncQueryResultsFactory {
    private static final AthenaLogger logger = AthenaLogger.of(GetQueryResultsQueryResultsFactory.class);
    private final AthenaAsyncClient athenaClient;
    private final Executor executor;
    private final ResultParserFactory resultParserFactory;
    private GetQueryResultsParser resultParser;

    public GetQueryResultsQueryResultsFactory(AthenaAsyncClient athenaClient, Executor executor, ResultParserFactory resultParserFactory) {
        this.athenaClient = athenaClient;
        this.executor = executor;
        this.resultParserFactory = resultParserFactory;
    }

    @Override
    public CompletionStage<AsyncQueryResults> create(QueryExecution queryMetadata) {
        logger.debug("Query execution {} loading the first page", queryMetadata.queryExecutionId());
        GetQueryResultsRequest request = (GetQueryResultsRequest)GetQueryResultsRequest.builder().queryExecutionId(queryMetadata.queryExecutionId()).build();
        this.resultParser = this.resultParserFactory.createGetQueryResultsResultRowsParser(queryMetadata);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.athenaClient.getQueryResults(request).exceptionally(e -> {
            logger.warn(String.format("Query execution %s failed loading result page: %s", queryMetadata.queryExecutionId(), e.getMessage()), (Throwable)e);
            throw new CompletionException(new QueryResultException(queryMetadata, String.format("Could not load query results: %s", e.getMessage()), (Throwable)e));
        })).thenApply(response -> ResultPage.of(response, this.resultParser))).whenComplete((resultPage, e) -> {
            if (e == null) {
                logger.info("Query execution {} loaded the first page, got {} rows (header included), {} more pages", queryMetadata.queryExecutionId(), resultPage.rows().size(), resultPage.nextToken() == null ? "no" : "has");
                if (resultPage.nextToken() != null) {
                    logger.trace("Query execution {} loaded the first page, next token is \"{}\"", queryMetadata.queryExecutionId(), resultPage.nextToken());
                }
            }
        })).thenApply(resultPage -> this.resultParser.getMetadataFetcher().getMetadata(queryMetadata, (ResultPage)resultPage))).thenApply(resultPage -> new GetQueryResultsQueryResults(this.athenaClient, this.executor, queryMetadata, (ResultPage)resultPage, this.resultParser));
    }
}

