/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.results.GetQueryResultsQueryResultsBase;
import com.amazon.athena.client.results.ResultPage;
import com.amazon.athena.client.results.parsing.GetQueryResultsStreamResponseParser;
import com.amazon.athena.logging.AthenaLogger;
import java.text.ParseException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athenastreaming.AthenaStreamingAsyncClient;
import software.amazon.awssdk.services.athenastreaming.model.GetQueryResultsStreamRequest;
import software.amazon.awssdk.services.athenastreaming.model.GetQueryResultsStreamResponse;

class GetQueryResultsStreamQueryResults
extends GetQueryResultsQueryResultsBase {
    private static final AthenaLogger logger = AthenaLogger.of(GetQueryResultsStreamQueryResults.class);
    private final AthenaStreamingAsyncClient athenaStreamingClient;
    private final int fetchSize;
    private final GetQueryResultsStreamResponseParser resultParser;

    GetQueryResultsStreamQueryResults(AthenaStreamingAsyncClient athenaStreamingClient, int fetchSize, Executor executor, QueryExecution queryExecution, ResultPage firstPage, GetQueryResultsStreamResponseParser resultParser) {
        super(executor, queryExecution, firstPage);
        this.athenaStreamingClient = athenaStreamingClient;
        this.fetchSize = fetchSize;
        this.resultParser = resultParser;
    }

    @Override
    protected CompletionStage<ResultPage> loadNextPage(String nextToken) {
        logger.debug("Query execution {} loading the next page of {} rows", this.queryExecution().queryExecutionId(), this.fetchSize);
        GetQueryResultsStreamRequest request = (GetQueryResultsStreamRequest)GetQueryResultsStreamRequest.builder().maxResults(Integer.valueOf(this.fetchSize)).queryExecutionId(this.queryExecution().queryExecutionId()).nextToken(nextToken).build();
        return this.athenaStreamingClient.getQueryResultsStream(request, AsyncResponseTransformer.toBlockingInputStream()).thenApply(this::parseResponse);
    }

    private ResultPage parseResponse(ResponseInputStream<GetQueryResultsStreamResponse> rawResponse) {
        try {
            return this.resultParser.parse(rawResponse);
        }
        catch (ParseException e) {
            throw new CompletionException(e);
        }
    }
}

