/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results.parsing.metadata;

import com.amazon.athena.client.results.ResultFormatHelper;
import com.amazon.athena.client.results.parsing.metadata.MetadataFetcher;
import com.amazon.athena.logging.AthenaLogger;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.QueryExecution;

public class S3StaticMetadataFetcher
implements MetadataFetcher {
    private static final AthenaLogger logger = AthenaLogger.of(S3StaticMetadataFetcher.class);
    private final QueryExecution queryMetadata;

    public S3StaticMetadataFetcher(QueryExecution queryMetadata) {
        this.queryMetadata = queryMetadata;
    }

    @Override
    public CompletableFuture<GetQueryResultsResponse> fetchMetadata() {
        logger.debug("Query execution {} not loading metadata, will use default plain text metadata", this.queryMetadata.queryExecutionId());
        CompletableFuture<Object> future = CompletableFuture.completedFuture(GetQueryResultsResponse.builder().resultSet(b -> b.resultSetMetadata(ResultFormatHelper.PLAIN_TEXT_RESULT_SET_METADATA)).build());
        return future;
    }
}

