/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc;

import com.amazon.athena.jdbc.AthenaDataType;
import com.amazon.athena.jdbc.support.AutoUnwrap;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import software.amazon.awssdk.services.athena.model.ColumnInfo;
import software.amazon.awssdk.services.athena.model.ColumnNullable;
import software.amazon.awssdk.services.athena.model.ResultSetMetadata;

public class AthenaResultSetMetaData
implements ResultSetMetaData,
AutoUnwrap {
    private final ResultSetMetadata athenaMetaData;

    public AthenaResultSetMetaData(ResultSetMetadata athenaMetaData) {
        this.athenaMetaData = athenaMetaData;
    }

    public int findColumnIndex(String columnLabel) {
        List columns = this.athenaMetaData.columnInfo();
        for (int i = 0; i < columns.size(); ++i) {
            if (!((ColumnInfo)columns.get(i)).label().equals(columnLabel)) continue;
            return i + 1;
        }
        return 0;
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
            throw new SQLException(String.format("Index %d is out of bounds for a result set with %d columns", columnIndex, this.getColumnCount()));
        }
    }

    private ColumnInfo columnInfo(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return (ColumnInfo)this.athenaMetaData.columnInfo().get(columnIndex - 1);
    }

    private AthenaDataType athenaDataType(int columnIndex) throws SQLException {
        return AthenaDataType.of(this.columnInfo(columnIndex).type());
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.athenaMetaData.columnInfo().size();
    }

    @Override
    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        return this.columnInfo(columnIndex).caseSensitive();
    }

    @Override
    public boolean isSearchable(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return true;
    }

    @Override
    public boolean isCurrency(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return false;
    }

    @Override
    public int isNullable(int columnIndex) throws SQLException {
        ColumnNullable nullability = this.columnInfo(columnIndex).nullable();
        switch (nullability) {
            case NULLABLE: {
                return 1;
            }
            case NOT_NULL: {
                return 0;
            }
        }
        return 2;
    }

    @Override
    public boolean isSigned(int columnIndex) throws SQLException {
        switch (this.athenaDataType(columnIndex)) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        return this.getPrecision(columnIndex);
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        return this.columnInfo(columnIndex).label();
    }

    @Override
    public String getColumnName(int columnIndex) throws SQLException {
        return this.columnInfo(columnIndex).name();
    }

    @Override
    public String getSchemaName(int columnInfo) throws SQLException {
        return this.columnInfo(columnInfo).schemaName();
    }

    @Override
    public int getPrecision(int columnIndex) throws SQLException {
        return this.columnInfo(columnIndex).precision();
    }

    @Override
    public int getScale(int columnIndex) throws SQLException {
        return this.columnInfo(columnIndex).scale();
    }

    @Override
    public String getTableName(int columnIndex) throws SQLException {
        return this.columnInfo(columnIndex).tableName();
    }

    @Override
    public String getCatalogName(int columnIndex) throws SQLException {
        return this.columnInfo(columnIndex).catalogName();
    }

    @Override
    public int getColumnType(int columnIndex) throws SQLException {
        return this.athenaDataType(columnIndex).jdbcType();
    }

    @Override
    public String getColumnTypeName(int columnIndex) throws SQLException {
        String columnTypeName = this.columnInfo(columnIndex).type();
        if (columnTypeName.equalsIgnoreCase(AthenaDataType.ROW.athenaName())) {
            return AthenaDataType.STRUCT.athenaName();
        }
        if (columnTypeName.equalsIgnoreCase(AthenaDataType.VARCHAR.athenaName()) && AthenaDataType.VARCHAR.maxSizeInBytes() < this.columnInfo(columnIndex).precision()) {
            return AthenaDataType.STRING.athenaName();
        }
        return columnTypeName;
    }

    @Override
    public boolean isReadOnly(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return true;
    }

    @Override
    public boolean isWritable(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return false;
    }

    @Override
    public String getColumnClassName(int columnIndex) throws SQLException {
        return this.athenaDataType(columnIndex).javaClass().getName();
    }
}

