/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.IdpCredentialsProvider;
import com.amazon.athena.jdbc.authentication.SamlCredentialsProvider;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lakeformation.LakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import software.amazon.awssdk.utils.IoUtils;

public class AdfsCredentialsProvider
extends SamlCredentialsProvider {
    private static final AthenaLogger logger = AthenaLogger.of(AdfsCredentialsProvider.class);
    private static final String URI_TEMPLATE = "https://%s:%s//adfs/ls/IdpInitiatedSignOn.aspx?loginToRp=%s";
    private static final String FORM_ACTION_URI_TEMPLATE = "https://%s:%s%s";
    private static final Pattern FORM_ACTION_PATTERN = Pattern.compile("<form.*?action=\"([^\"]+)\"");
    private static final Pattern SAML_ASSERTION_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");
    private final String username;
    private final String password;
    private final String hostName;
    private final Integer portNumber;
    private final String relyingParty;
    private final Boolean wiaEnabled;
    private final String osName;
    private final ProcessBuilder processBuilder;
    private final ClassLoader classLoader;
    private final IoExceptionThrowingConsumer<Path> filesDeleter;
    private final Optional<Boolean> useProxyForIdp;
    private final Optional<String> proxyHost;
    private final Optional<Integer> proxyPort;
    private final Optional<String> proxyUsername;
    private final Optional<String> proxyPassword;
    private final Supplier<CloseableHttpClient> httpClientFactory;

    private AdfsCredentialsProvider(String username, String password, String hostName, Integer portNumber, String relyingParty, boolean wiaEnabled, String osName, ProcessBuilder processBuilder, ClassLoader classLoader, IoExceptionThrowingConsumer<Path> filesDeleter, String preferredRole, Integer roleSessionDuration, Region region, Supplier<CloseableHttpClient> httpClientFactory, AssumeRoleWithSamlRequest.Builder assumeRoleRequestFactory, StsClientBuilder stsClientFactory, AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleRequestFactory, LakeFormationClientBuilder lakeFormationClientFactory, boolean lakeFormationEnabled, Map<ConnectionParameter<?>, String> parameters) {
        super(assumeRoleRequestFactory, assumeDecoratedRoleRequestFactory, stsClientFactory, lakeFormationClientFactory, null, null, preferredRole, roleSessionDuration, region, lakeFormationEnabled, parameters);
        this.username = username;
        this.password = password;
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.relyingParty = relyingParty;
        this.wiaEnabled = wiaEnabled;
        this.osName = osName == null ? System.getProperty("os.name") : osName;
        this.processBuilder = processBuilder == null ? new ProcessBuilder(new String[0]) : processBuilder;
        this.classLoader = classLoader == null ? AdfsCredentialsProvider.class.getClassLoader() : classLoader;
        this.filesDeleter = filesDeleter == null ? Files::delete : filesDeleter;
        this.useProxyForIdp = ConnectionParameters.PROXY_ENABLED_FOR_IDP_PARAMETER.findValue(parameters);
        this.proxyHost = ConnectionParameters.PROXY_HOST_PARAMETER.findValue(parameters);
        this.proxyPort = ConnectionParameters.PROXY_PORT_PARAMETER.findValue(parameters);
        this.proxyUsername = ConnectionParameters.PROXY_USERNAME_PARAMETER.findValue(parameters);
        this.proxyPassword = ConnectionParameters.PROXY_PASSWORD_PARAMETER.findValue(parameters);
        this.httpClientFactory = httpClientFactory == null ? () -> IdpCredentialsProvider.createHttpClient(parameters) : httpClientFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String getSamlAssertion() {
        if (!this.wiaEnabled.booleanValue()) {
            logger.info("Using form-based AD FS authentication as Windows integrated authentication is not enabled.", new Object[0]);
            return this.formBasedAuthentication();
        }
        logger.info("Using Windows integrated AD FS authentication as it is enabled.", new Object[0]);
        WindowsIntegratedAuthenticationController wia = new WindowsIntegratedAuthenticationController(this.hostName, this.portNumber, this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword, this.useProxyForIdp, this.osName, this.processBuilder, this.classLoader, this.filesDeleter);
        return wia.authenticate();
    }

    private String formBasedAuthentication() {
        if (this.username != null && this.password != null) {
            URI uri = this.constructAdfsEndpoint();
            logger.info("Making a request to get the form action from the AD FS URI: {}", uri);
            HttpGet get = new HttpGet(uri);
            String responseString = this.getHttpResponse(get);
            String action = this.getFormAction(responseString);
            if (action != null && action.startsWith("/")) {
                uri = this.constructFormActionEndpoint(action);
            }
            logger.info("Making a request to get SAML assertion from the form action URI: {}", uri);
            HttpPost request = this.createSamlRequest(uri);
            return this.fetchSamlAssertion(request);
        }
        throw new AuthenticationException("Both username and password must be provided to use AD FS form based authentication");
    }

    private URI constructAdfsEndpoint() {
        try {
            return new URI(String.format(URI_TEMPLATE, this.hostName, this.portNumber, this.relyingParty));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Could not construct a valid AD FS endpoint URL from the provided host (\"%s\"), port (\"%s\"), and relying party (\"%s\")", this.hostName, this.portNumber, this.relyingParty), e);
        }
    }

    private URI constructFormActionEndpoint(String action) {
        try {
            return new URI(String.format(FORM_ACTION_URI_TEMPLATE, this.hostName, this.portNumber, action));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Could not construct a valid AD FS form action endpoint URL from the provided host (\"%s\"), port (\"%s\"), and form action (\"%s\")", this.hostName, this.portNumber, action), e);
        }
    }

    /*
     * Exception decompiling
     */
    private String getHttpResponse(HttpGet request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpPost createSamlRequest(URI uri) {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(2);
        parameters.add(new BasicNameValuePair("username", this.username));
        parameters.add(new BasicNameValuePair("password", this.password));
        HttpPost post = new HttpPost(uri);
        post.addHeader("Content-Type", "application/x-www-form-urlencoded");
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8));
        return post;
    }

    /*
     * Exception decompiling
     */
    private String fetchSamlAssertion(HttpPost request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateHttpResponse(CloseableHttpResponse response) {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new AuthenticationException(String.format("Unexpected error from AD FS (HTTP response status code %s)", response.getStatusLine().getStatusCode()));
        }
    }

    private String extractResponseBody(CloseableHttpResponse response) {
        try {
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new AuthenticationException("An error occurred while processing the response from AD FS", e);
        }
    }

    private String extractSamlAssertion(String responseString) {
        Matcher samlAssertionMatcher = SAML_ASSERTION_PATTERN.matcher(responseString);
        if (samlAssertionMatcher.find()) {
            return samlAssertionMatcher.group(1);
        }
        throw new AuthenticationException("Unable to extract the SAMLResponse field from the response body");
    }

    private String getFormAction(String responseString) {
        Matcher formActionMatcher = FORM_ACTION_PATTERN.matcher(responseString);
        if (formActionMatcher.find()) {
            return this.decodeHtmlCharacterReferences(formActionMatcher.group(1));
        }
        return null;
    }

    static class WindowsIntegratedAuthenticationController {
        private final String hostName;
        private final Integer portNumber;
        private final Optional<String> proxyHost;
        private final Optional<Integer> proxyPort;
        private final Optional<String> proxyUsername;
        private final Optional<String> proxyPassword;
        private final Optional<Boolean> useProxyForIdp;
        private final ProcessBuilder processBuilder;
        private final ClassLoader classLoader;
        private final IoExceptionThrowingConsumer<Path> filesDeleter;

        public WindowsIntegratedAuthenticationController(String hostName, Integer portNumber, Optional<String> proxyHost, Optional<Integer> proxyPort, Optional<String> proxyUsername, Optional<String> proxyPassword, Optional<Boolean> useProxyForIdp, String osName, ProcessBuilder processBuilder, ClassLoader classLoader, IoExceptionThrowingConsumer<Path> filesDeleter) {
            this.hostName = hostName;
            this.portNumber = portNumber;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUsername = proxyUsername;
            this.proxyPassword = proxyPassword;
            this.useProxyForIdp = useProxyForIdp;
            this.processBuilder = processBuilder;
            this.classLoader = classLoader;
            this.filesDeleter = filesDeleter;
            if (!osName.toLowerCase().contains("windows")) {
                throw new AuthenticationException("Windows integrated AD FS authentication is only supported on Windows platforms.");
            }
        }

        private String authenticate() {
            int exitCode;
            Path executablePath;
            block9: {
                executablePath = this.extractAuthenticationExecutable(this.classLoader, "adfs.exe");
                String[] command = this.useProxyForIdp.isPresent() && this.useProxyForIdp.get() != false && this.proxyHost.isPresent() && this.proxyPort.isPresent() ? new String[]{executablePath.toString(), this.hostName, String.valueOf(this.portNumber), this.proxyUsername.orElse(""), this.proxyPassword.orElse("")} : new String[]{executablePath.toString(), this.hostName, String.valueOf(this.portNumber)};
                this.processBuilder.command(command);
                this.processBuilder.redirectErrorStream(true);
                logger.info("Start the AD FS executable with the parameters {}", this.sanitizeCommand(command));
                Process process = this.processBuilder.start();
                String samlAssertion = IoUtils.toUtf8String((InputStream)process.getInputStream());
                exitCode = process.waitFor();
                if (exitCode != 0) break block9;
                String string = samlAssertion;
                try {
                    this.filesDeleter.accept(executablePath);
                    logger.info("Deleted the temporary file \"{}\"", executablePath.toString());
                }
                catch (IOException e) {
                    throw new AuthenticationException("Failed to delete AD FS authentication executable.", e);
                }
                return string;
            }
            try {
                try {
                    throw new AuthenticationException("AD FS process returned incorrect code: " + exitCode);
                }
                catch (IOException | InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new AuthenticationException("Failed to execute AD FS command.", e);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.filesDeleter.accept(executablePath);
                    logger.info("Deleted the temporary file \"{}\"", executablePath.toString());
                }
                catch (IOException e) {
                    throw new AuthenticationException("Failed to delete AD FS authentication executable.", e);
                }
                throw throwable;
            }
        }

        private String sanitizeCommand(String[] command) {
            if (command.length == 3) {
                return String.join((CharSequence)" ", command);
            }
            return String.join((CharSequence)" ", command[0], command[1], command[2], command[3], "<sanitized-password>");
        }

        private Path extractAuthenticationExecutable(ClassLoader classLoader, String fileName) {
            try {
                InputStream inputStream = classLoader.getResourceAsStream(fileName);
                Path tempFile = Files.createTempFile("adfs", ".tmp", new FileAttribute[0]);
                Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
                return Paths.get(tempFile.toString(), new String[0]);
            }
            catch (IOException e) {
                logger.warn("Failed to extract AD FS authentication executable \"{}\"", fileName);
                throw new AuthenticationException("Failed to extract AD FS authentication executable.", e);
            }
        }
    }

    public static class Builder {
        private String username;
        private String password;
        private String hostName;
        private String relyingParty;
        private boolean wiaEnabled;
        private String osName;
        private ProcessBuilder processBuilder;
        private ClassLoader classLoader;
        private IoExceptionThrowingConsumer<Path> filesDeleter;
        private Integer portNumber;
        private String preferredRole;
        private Integer roleSessionDuration;
        private Region region;
        private boolean lakeFormationEnabled;
        private Supplier<CloseableHttpClient> httpClientFactory;
        private AssumeRoleWithSamlRequest.Builder assumeRoleWithSamlRequestFactory;
        private AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleWithSamlRequestFactory;
        private StsClientBuilder stsClientFactory;
        private LakeFormationClientBuilder lakeFormationClientFactory;
        private Map<ConnectionParameter<?>, String> parameters;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder relyingParty(String relyingParty) {
            this.relyingParty = relyingParty;
            return this;
        }

        public Builder wiaEnabled(boolean wiaEnabled) {
            this.wiaEnabled = wiaEnabled;
            return this;
        }

        public Builder osName(String osName) {
            this.osName = osName;
            return this;
        }

        Builder processBuilder(ProcessBuilder processBuilder) {
            this.processBuilder = processBuilder;
            return this;
        }

        Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        Builder filesDeleter(IoExceptionThrowingConsumer<Path> filesDeleter) {
            this.filesDeleter = filesDeleter;
            return this;
        }

        public Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public Builder preferredRole(String preferredRole) {
            this.preferredRole = preferredRole;
            return this;
        }

        public Builder roleSessionDuration(Integer roleSessionDuration) {
            this.roleSessionDuration = roleSessionDuration;
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder lakeFormationEnabled(boolean lakeFormationEnabled) {
            this.lakeFormationEnabled = lakeFormationEnabled;
            return this;
        }

        Builder httpClientFactory(Supplier<CloseableHttpClient> httpClientFactory) {
            this.httpClientFactory = httpClientFactory;
            return this;
        }

        Builder assumeRoleWithSamlRequestFactory(AssumeRoleWithSamlRequest.Builder assumeRoleWithSamlRequestFactory) {
            this.assumeRoleWithSamlRequestFactory = assumeRoleWithSamlRequestFactory;
            return this;
        }

        Builder assumeDecoratedRoleWithSamlRequestFactory(AssumeDecoratedRoleWithSamlRequest.Builder assumeDecoratedRoleWithSamlRequestFactory) {
            this.assumeDecoratedRoleWithSamlRequestFactory = assumeDecoratedRoleWithSamlRequestFactory;
            return this;
        }

        Builder stsClientBuilder(StsClientBuilder stsClientFactory) {
            this.stsClientFactory = stsClientFactory;
            return this;
        }

        Builder lakeFormationClientBuilder(LakeFormationClientBuilder lakeFormationClientFactory) {
            this.lakeFormationClientFactory = lakeFormationClientFactory;
            return this;
        }

        public Builder connectionParameters(Map<ConnectionParameter<?>, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public AdfsCredentialsProvider build() {
            return new AdfsCredentialsProvider(this.username, this.password, this.hostName, this.portNumber, this.relyingParty, this.wiaEnabled, this.osName, this.processBuilder, this.classLoader, this.filesDeleter, this.preferredRole, this.roleSessionDuration, this.region, this.httpClientFactory, this.assumeRoleWithSamlRequestFactory, this.stsClientFactory, this.assumeDecoratedRoleWithSamlRequestFactory, this.lakeFormationClientFactory, this.lakeFormationEnabled, this.parameters);
        }
    }

    @FunctionalInterface
    static interface IoExceptionThrowingConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

