/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.AzureAdCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.BrowserAzureCredentialsProvider;
import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class BrowserAzureCredentialsProviderFactory
implements CredentialsProviderFactory {
    private final BrowserAzureCredentialsProvider.Builder credentialsProviderBuilder;

    public BrowserAzureCredentialsProviderFactory() {
        this.credentialsProviderBuilder = BrowserAzureCredentialsProvider.builder();
    }

    BrowserAzureCredentialsProviderFactory(BrowserAzureCredentialsProvider.Builder credentialsProviderBuilder) {
        this.credentialsProviderBuilder = credentialsProviderBuilder;
    }

    @Override
    public String name() {
        return "BrowserAzureAD";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        ArrayList required = new ArrayList();
        required.add(AzureAdCredentialsProviderFactory.AZURE_AD_TENANT_ID);
        required.add(AzureAdCredentialsProviderFactory.AZURE_AD_CLIENT_ID);
        ConnectionParameters.checkIfPresentAndThrow(required, parameters);
        Optional<String> clientId = AzureAdCredentialsProviderFactory.AZURE_AD_CLIENT_ID.findValue(parameters);
        Optional<String> tenantId = AzureAdCredentialsProviderFactory.AZURE_AD_TENANT_ID.findValue(parameters);
        Optional<String> preferredRole = ConnectionParameters.PREFERRED_ROLE_PARAMETER.findValue(parameters);
        Optional<Integer> roleSessionDuration = ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.findValue(parameters);
        Optional<Integer> idpResponseTimeout = ConnectionParameters.IDP_RESPONSE_TIMEOUT.findValue(parameters);
        Integer response_timeout = Math.max(60, idpResponseTimeout.orElse(120));
        Optional<Region> region = ConnectionParameters.REGION_PARAMETER.findValue(parameters);
        Optional<Boolean> lakeFormationEnabled = ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER.findValue(parameters);
        return this.credentialsProviderBuilder.tenantId(tenantId.get()).clientId(clientId.get()).preferredRole(preferredRole.orElse(null)).roleSessionDuration(roleSessionDuration.orElse(null)).region(region.get()).lakeFormationEnabled(lakeFormationEnabled.get()).idpResponseTimeout(response_timeout).connectionParameters(parameters).build();
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.IDP_RESPONSE_TIMEOUT, ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER, ConnectionParameters.PREFERRED_ROLE_PARAMETER, ConnectionParameters.REGION_PARAMETER, ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER, AzureAdCredentialsProviderFactory.AZURE_AD_CLIENT_ID, AzureAdCredentialsProviderFactory.AZURE_AD_TENANT_ID);
    }
}

