/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.BrowserOidcTrustedIdentityPropagationCredentialsProvider;
import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.TrustedIdentityPropagationAuthenticationWorkflow;
import com.amazon.athena.jdbc.authentication.http.BrowserAuthenticationServer;
import com.amazon.athena.jdbc.authentication.http.HttpClientFactory;
import com.amazon.athena.jdbc.authentication.http.ProxyAwareHttpClientFactory;
import com.amazon.athena.jdbc.authentication.oidc.AuthorizationCodeOpenIdConnectFlow;
import com.amazon.athena.jdbc.authentication.oidc.JwtTokenValidator;
import com.amazon.athena.jdbc.authentication.oidc.OpenIdConnectWellKnownConfigurationService;
import com.amazon.athena.jdbc.authentication.utils.JwtTrustedIdentityProviderUtils;
import com.amazon.athena.jdbc.cache.Cache;
import com.amazon.athena.jdbc.cache.CacheManager;
import com.amazon.athena.jdbc.cache.JwtTokenCacheEntry;
import com.amazon.athena.jdbc.cache.TokenCacheEntry;
import com.amazon.athena.jdbc.cache.WellKnownConfigurationCacheEntry;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import com.amazon.athena.jdbc.support.EndpointHelper;
import com.amazon.athena.jdbc.support.ProxyHelper;
import java.awt.Desktop;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;

public class BrowserOidcTrustedIdentityPropagationCredentialsProviderFactory
implements CredentialsProviderFactory {
    private static final int DEFAULT_PORT = 7890;
    private static final int DEFAULT_SERVER_TIMEOUT = 120;
    private static final int DEFAULT_ROLE_SESSION_DURATION = 3600;
    private static final String DEFAULT_SCOPE_PARAMETER_VALUE = "openid email offline_access";
    private static final List<ConnectionParameter<?>> REQUIRED_PARAMETERS = Arrays.asList(ConnectionParameters.APPLICATION_ROLE_ARN_PARAMETER, ConnectionParameters.IDP_WELL_KNOWN_CONFIGURATION_URL_PARAMETER, ConnectionParameters.OIDC_CLIENT_ID_PARAMETER, ConnectionParameters.WORKGROUP_ARN_PARAMETER, ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER);
    private Desktop desktop;
    private final Cache<TokenCacheEntry> idcTokenCache;
    private final Cache<JwtTokenCacheEntry> jwtTokenCache;
    private final Cache<WellKnownConfigurationCacheEntry> wellKnownConfigCache;

    public BrowserOidcTrustedIdentityPropagationCredentialsProviderFactory(CacheManager cacheManager) {
        this.jwtTokenCache = cacheManager.getCache(JwtTokenCacheEntry.class);
        this.idcTokenCache = cacheManager.getCache(TokenCacheEntry.class);
        this.wellKnownConfigCache = cacheManager.getCache(WellKnownConfigurationCacheEntry.class);
    }

    protected BrowserOidcTrustedIdentityPropagationCredentialsProviderFactory(CacheManager cacheManager, Desktop desktop) {
        this.jwtTokenCache = cacheManager.getCache(JwtTokenCacheEntry.class);
        this.idcTokenCache = cacheManager.getCache(TokenCacheEntry.class);
        this.wellKnownConfigCache = cacheManager.getCache(WellKnownConfigurationCacheEntry.class);
        this.desktop = desktop == null ? Desktop.getDesktop() : desktop;
    }

    @Override
    public String name() {
        return "BrowserOidcTip";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        this.validateParameters(parameters);
        String clientId = ConnectionParameters.OIDC_CLIENT_ID_PARAMETER.findValue(parameters).get();
        Boolean enableTokenCache = ConnectionParameters.ENABLE_TOKEN_CACHING_PARAMETER.findValue(parameters).orElse(Boolean.FALSE);
        String applicationRoleArn = ConnectionParameters.APPLICATION_ROLE_ARN_PARAMETER.findValue(parameters).get();
        String workgroupArn = ConnectionParameters.WORKGROUP_ARN_PARAMETER.findValue(parameters).get();
        String roleSessionName = ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER.findValue(parameters).get();
        ProxyConfiguration proxyConfiguration = ProxyHelper.getSyncProxyConfiguration(parameters).orElse(null);
        String cacheKeyForTokenCache = this.constructCacheKeyForWebIdentityToken(applicationRoleArn, workgroupArn, roleSessionName);
        ProxyAwareHttpClientFactory httpClientFactory = new ProxyAwareHttpClientFactory(proxyConfiguration);
        String openIdConnectWellKnownConfigurationUrl = ConnectionParameters.IDP_WELL_KNOWN_CONFIGURATION_URL_PARAMETER.findValue(parameters).get();
        OpenIdConnectWellKnownConfigurationService openIdConnectWellKnownConfigurationService = this.createOpenIdConnectWellKnownConfigurationService(openIdConnectWellKnownConfigurationUrl, httpClientFactory);
        JwtTokenValidator jwtTokenValidator = new JwtTokenValidator(clientId, openIdConnectWellKnownConfigurationService);
        AuthorizationCodeOpenIdConnectFlow authorizationCodeFlow = this.createAuthorizationCodeOpenIdConnectFlow(parameters, httpClientFactory, jwtTokenValidator, openIdConnectWellKnownConfigurationService);
        JwtTrustedIdentityProviderUtils jwtTrustedIdentityProviderUtils = this.createJwtTrustedIdentityProviderUtils(parameters, proxyConfiguration);
        TrustedIdentityPropagationAuthenticationWorkflow trustedIdentityPropagationAuthenticationWorkflow = this.createTrustedIdentityPropagationAuthenticationWorkflow(parameters, applicationRoleArn, workgroupArn, roleSessionName, jwtTrustedIdentityProviderUtils);
        return new BrowserOidcTrustedIdentityPropagationCredentialsProvider(enableTokenCache, cacheKeyForTokenCache, authorizationCodeFlow, this.jwtTokenCache, trustedIdentityPropagationAuthenticationWorkflow);
    }

    private String constructCacheKeyForWebIdentityToken(String applicationRoleArn, String workgroupArn, String roleSessionName) {
        return String.format("%s_%s_%s", applicationRoleArn, workgroupArn, roleSessionName);
    }

    private OpenIdConnectWellKnownConfigurationService createOpenIdConnectWellKnownConfigurationService(String openIdConnectWellKnownConfigurationUrl, HttpClientFactory httpClientFactory) {
        return new OpenIdConnectWellKnownConfigurationService(openIdConnectWellKnownConfigurationUrl, httpClientFactory, this.wellKnownConfigCache);
    }

    private JwtTrustedIdentityProviderUtils createJwtTrustedIdentityProviderUtils(Map<ConnectionParameter<?>, String> parameters, ProxyConfiguration proxyConfiguration) {
        Region region = ConnectionParameters.REGION_PARAMETER.findValue(parameters).orElse(null);
        URI stsEndpoint = ConnectionParameters.STS_ENDPOINT_PARAMETER.findValue(parameters).map(endpoint -> EndpointHelper.constructEndpointUri(endpoint, "STS")).orElse(null);
        URI ssoOidcEndpoint = ConnectionParameters.SSO_OIDC_ENDPOINT_PARAMETER.findValue(parameters).map(endpoint -> EndpointHelper.constructEndpointUri(endpoint, "SSO OIDC")).orElse(null);
        URI ssoAdminEndpoint = ConnectionParameters.SSO_ADMIN_ENDPOINT_PARAMETER.findValue(parameters).map(endpoint -> EndpointHelper.constructEndpointUri(endpoint, "SSO Admin")).orElse(null);
        Optional<String> host = ConnectionParameters.HOST.findValue(parameters);
        Optional<String> athenaEndpoint = ConnectionParameters.ATHENA_ENDPOINT_PARAMETER.findValue(parameters);
        return new JwtTrustedIdentityProviderUtils(region, stsEndpoint, proxyConfiguration, host, athenaEndpoint, ssoOidcEndpoint, ssoAdminEndpoint);
    }

    private AuthorizationCodeOpenIdConnectFlow createAuthorizationCodeOpenIdConnectFlow(Map<ConnectionParameter<?>, String> parameters, HttpClientFactory httpClientFactory, JwtTokenValidator jwtTokenValidator, OpenIdConnectWellKnownConfigurationService openIdConnectWellKnownConfigurationService) {
        String clientId = ConnectionParameters.OIDC_CLIENT_ID_PARAMETER.findValue(parameters).get();
        String clientSecret = ConnectionParameters.OIDC_CLIENT_SECRET_PARAMETER.findValue(parameters).orElse(null);
        String scope = ConnectionParameters.SCOPE_PARAMETER.findValue(parameters).orElse(DEFAULT_SCOPE_PARAMETER_VALUE);
        int localServerPort = ConnectionParameters.IDP_PORT_NUMBER.findValue(parameters).orElse(7890);
        Integer localServerTimeout = ConnectionParameters.IDP_RESPONSE_TIMEOUT.findValue(parameters).orElse(120);
        return new AuthorizationCodeOpenIdConnectFlow(clientId, clientSecret, scope, localServerPort, localServerTimeout, this.desktop == null ? Desktop.getDesktop() : this.desktop, new BrowserAuthenticationServer(localServerPort), openIdConnectWellKnownConfigurationService, jwtTokenValidator, httpClientFactory);
    }

    private TrustedIdentityPropagationAuthenticationWorkflow createTrustedIdentityPropagationAuthenticationWorkflow(Map<ConnectionParameter<?>, String> parameters, String applicationRoleArn, String workgroupArn, String roleSessionName, JwtTrustedIdentityProviderUtils jwtTrustedIdentityProviderUtils) {
        String customerIdcApplicationArn = ConnectionParameters.CUSTOMER_IDC_APPLICATION_ARN.findValue(parameters).orElse(null);
        String accessRoleArn = ConnectionParameters.ACCESS_ROLE_ARN_PARAMETER.findValue(parameters).orElse(null);
        Integer roleSessionDuration = ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.findValue(parameters).orElse(3600);
        return new TrustedIdentityPropagationAuthenticationWorkflow(applicationRoleArn, workgroupArn, customerIdcApplicationArn, accessRoleArn, roleSessionName, roleSessionDuration, jwtTrustedIdentityProviderUtils, this.idcTokenCache);
    }

    private void validateParameters(Map<ConnectionParameter<?>, String> parameters) {
        String errorMessage = REQUIRED_PARAMETERS.stream().filter(parameter -> !parameter.findValue(parameters).isPresent()).map(missingParameter -> String.format("The %s parameter must be specified when using the %s credentials provider", missingParameter.name(), this.name())).collect(Collectors.joining("; "));
        if (!errorMessage.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.REGION_PARAMETER, ConnectionParameters.IDP_WELL_KNOWN_CONFIGURATION_URL_PARAMETER, ConnectionParameters.OIDC_CLIENT_ID_PARAMETER, ConnectionParameters.OIDC_CLIENT_SECRET_PARAMETER, ConnectionParameters.SCOPE_PARAMETER, ConnectionParameters.ENABLE_TOKEN_CACHING_PARAMETER, ConnectionParameters.IDP_PORT_NUMBER, ConnectionParameters.IDP_RESPONSE_TIMEOUT, ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER, ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER, ConnectionParameters.ACCESS_ROLE_ARN_PARAMETER, ConnectionParameters.CUSTOMER_IDC_APPLICATION_ARN, ConnectionParameters.APPLICATION_ROLE_ARN_PARAMETER, ConnectionParameters.WORKGROUP_ARN_PARAMETER);
    }
}

