/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.BrowserSamlCredentialsProvider;
import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class BrowserSamlCredentialsProviderFactory
implements CredentialsProviderFactory {
    private final BrowserSamlCredentialsProvider.Builder credentialsProviderBuilder;

    public BrowserSamlCredentialsProviderFactory() {
        this.credentialsProviderBuilder = BrowserSamlCredentialsProvider.builder();
    }

    BrowserSamlCredentialsProviderFactory(BrowserSamlCredentialsProvider.Builder credentialsProviderBuilder) {
        this.credentialsProviderBuilder = credentialsProviderBuilder;
    }

    @Override
    public String name() {
        return "BrowserSaml";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        ArrayList required = new ArrayList();
        required.add(ConnectionParameters.SSO_LOGIN_URL);
        ConnectionParameters.checkIfPresentAndThrow(required, parameters);
        Optional<String> ssoLogin = ConnectionParameters.SSO_LOGIN_URL.findValue(parameters);
        Optional<String> preferredRole = ConnectionParameters.PREFERRED_ROLE_PARAMETER.findValue(parameters);
        Optional<Integer> roleSessionDuration = ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.findValue(parameters);
        Optional<Integer> idpResponseTimeout = ConnectionParameters.IDP_RESPONSE_TIMEOUT.findValue(parameters);
        Integer response_timeout = Math.max(60, idpResponseTimeout.orElse(120));
        Optional<Integer> listenPort = ConnectionParameters.LISTEN_PORT.findValue(parameters);
        Integer listen_port = listenPort.orElse(7890);
        Optional<Region> region = ConnectionParameters.REGION_PARAMETER.findValue(parameters);
        Optional<Boolean> lakeFormationEnabled = ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER.findValue(parameters);
        return this.credentialsProviderBuilder.loginUrl(ssoLogin.get()).preferredRole(preferredRole.orElse(null)).roleSessionDuration(roleSessionDuration.orElse(null)).region(region.get()).lakeFormationEnabled(lakeFormationEnabled.get()).idpResponseTimeout(response_timeout).listenPort(listen_port).connectionParameters(parameters).build();
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.IDP_RESPONSE_TIMEOUT, ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER, ConnectionParameters.LISTEN_PORT, ConnectionParameters.PREFERRED_ROLE_PARAMETER, ConnectionParameters.REGION_PARAMETER, ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER, ConnectionParameters.SSO_LOGIN_URL);
    }
}

