/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.logging.AthenaLogger;
import java.time.Clock;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.Credentials;

public class JwtCredentialsProvider
implements AwsCredentialsProvider {
    private static final AthenaLogger logger = AthenaLogger.of(JwtCredentialsProvider.class);
    private static final int EXPIRATION_THRESHOLD_SECS = 180;
    private final String webIdentityToken;
    private final String roleArn;
    private final String roleSessionName;
    private final Integer roleSessionDuration;
    private final StsClient stsClient;
    private final Clock clock;
    private AwsSessionCredentials credentials;

    JwtCredentialsProvider(String webIdentityToken, String roleArn, String roleSessionName, Integer roleSessionDuration, StsClient stsClient) {
        this(webIdentityToken, roleArn, roleSessionName, roleSessionDuration, stsClient, Clock.systemDefaultZone());
    }

    JwtCredentialsProvider(String webIdentityToken, String roleArn, String roleSessionName, Integer roleSessionDuration, StsClient stsClient, Clock clock) {
        this.webIdentityToken = webIdentityToken;
        this.roleArn = roleArn;
        this.roleSessionName = roleSessionName;
        this.roleSessionDuration = roleSessionDuration;
        this.stsClient = stsClient;
        this.clock = clock;
    }

    public AwsCredentials resolveCredentials() {
        boolean needsUpdate = Optional.ofNullable(this.credentials).flatMap(credentials -> credentials.expirationTime().map(t -> t.compareTo(this.clock.instant().plusSeconds(180L)) < 0)).orElse(true);
        if (needsUpdate) {
            this.credentials = this.obtainCredentialsFromSts();
        }
        return this.credentials;
    }

    private AwsSessionCredentials obtainCredentialsFromSts() {
        AssumeRoleWithWebIdentityRequest request = (AssumeRoleWithWebIdentityRequest)AssumeRoleWithWebIdentityRequest.builder().webIdentityToken(this.webIdentityToken).roleArn(this.roleArn).roleSessionName(this.roleSessionName).durationSeconds(this.roleSessionDuration).build();
        logger.debug("Obtaining credentials from STS", new Object[0]);
        logger.trace("Sending AssumeRoleWithWebIdentity request: {}", request);
        AssumeRoleWithWebIdentityResponse response = this.stsClient.assumeRoleWithWebIdentity(request);
        logger.info("Obtained credentials from STS", new Object[0]);
        Credentials stsCredentials = response.credentials();
        return AwsSessionCredentials.builder().accessKeyId(stsCredentials.accessKeyId()).secretAccessKey(stsCredentials.secretAccessKey()).sessionToken(stsCredentials.sessionToken()).expirationTime(stsCredentials.expiration()).build();
    }
}

