/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.JwtCredentialsProvider;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import com.amazon.athena.jdbc.support.EndpointHelper;
import com.amazon.athena.jdbc.support.ProxyHelper;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;

public class JwtCredentialsProviderFactory
implements CredentialsProviderFactory {
    public static final ConnectionParameter<String> JWT_ROLE_ARN_PARAMETER = ConnectionParameter.builder().name("JwtRoleArn").deprecatedAlias("role_arn").build();
    private static final List<ConnectionParameter<?>> REQUIRED_PARAMETERS = Arrays.asList(ConnectionParameters.JWT_WEB_IDENTITY_TOKEN_PARAMETER, ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER, JWT_ROLE_ARN_PARAMETER);
    private final Supplier<StsClientBuilder> stsClientBuilderFactory;
    private final Supplier<ApacheHttpClient.Builder> httpClientBuilderFactory;

    public JwtCredentialsProviderFactory() {
        this(StsClient::builder, ApacheHttpClient::builder);
    }

    JwtCredentialsProviderFactory(Supplier<StsClientBuilder> stsClientBuilderFactory, Supplier<ApacheHttpClient.Builder> httpClientBuilderFactory) {
        this.stsClientBuilderFactory = stsClientBuilderFactory;
        this.httpClientBuilderFactory = httpClientBuilderFactory;
    }

    @Override
    public String name() {
        return "JWT";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        this.validateParameters(parameters);
        String roleArn = JWT_ROLE_ARN_PARAMETER.findValue(parameters).get();
        String webIdentityToken = ConnectionParameters.JWT_WEB_IDENTITY_TOKEN_PARAMETER.findValue(parameters).get();
        String roleSessionName = ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER.findValue(parameters).get();
        Integer roleSessionDuration = ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.findValue(parameters).orElse(null);
        Region region = ConnectionParameters.REGION_PARAMETER.findValue(parameters).orElse(null);
        ProxyConfiguration proxyConfiguration = ProxyHelper.getSyncProxyConfiguration(parameters).orElse(null);
        URI stsEndpoint = ConnectionParameters.STS_ENDPOINT_PARAMETER.findValue(parameters).map(endpoint -> EndpointHelper.constructEndpointUri(endpoint, "STS")).orElse(null);
        StsClient stsClient = this.createStsClient(region, proxyConfiguration, stsEndpoint);
        return new JwtCredentialsProvider(webIdentityToken, roleArn, roleSessionName, roleSessionDuration, stsClient);
    }

    private void validateParameters(Map<ConnectionParameter<?>, String> parameters) {
        String errorMessage = REQUIRED_PARAMETERS.stream().filter(parameter -> !parameter.findValue(parameters).isPresent()).map(missingParameter -> String.format("The %s parameter must be specified when using the %s credentials provider", missingParameter.name(), this.name())).collect(Collectors.joining("; "));
        if (!errorMessage.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private StsClient createStsClient(Region region, ProxyConfiguration proxyConfiguration, URI stsEndpoint) {
        StsClientBuilder stsClientBuilder = this.stsClientBuilderFactory.get();
        if (proxyConfiguration != null) {
            ApacheHttpClient.Builder httpClientBuilder = this.httpClientBuilderFactory.get().proxyConfiguration(proxyConfiguration);
            stsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        if (stsEndpoint != null) {
            stsClientBuilder.endpointOverride(stsEndpoint);
        }
        return (StsClient)((StsClientBuilder)((StsClientBuilder)stsClientBuilder.region(region)).credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).build();
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.REGION_PARAMETER, ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER, ConnectionParameters.JWT_ROLE_SESSION_NAME_PARAMETER, ConnectionParameters.JWT_WEB_IDENTITY_TOKEN_PARAMETER, JWT_ROLE_ARN_PARAMETER);
    }
}

