/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.datazone;

import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.datazone.DataZoneCredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.datazone.DataZoneIdcCredentialsProvider;
import com.amazon.athena.jdbc.authentication.datazone.helpers.BrowserControlHelper;
import com.amazon.athena.jdbc.authentication.datazone.helpers.DataZoneHelper;
import com.amazon.athena.jdbc.authentication.datazone.helpers.SsoOidcHelper;
import com.amazon.athena.jdbc.authentication.datazone.httpserver.Server;
import com.amazon.athena.jdbc.authentication.datazone.utils.DataZoneEndpointUtils;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.DataZoneClientBuilder;
import software.amazon.awssdk.services.ssooidc.SsoOidcClient;
import software.amazon.awssdk.services.ssooidc.SsoOidcClientBuilder;

public class DataZoneIdcCredentialsProviderFactory
extends DataZoneCredentialsProviderFactory
implements CredentialsProviderFactory {
    public static final ConnectionParameter<String> IDENTITY_CENTER_ISSUER_URL_PARAMETER = ConnectionParameter.builder().name("IdentityCenterIssuerUrl").build();
    private static final List<ConnectionParameter<?>> REQUIRED_PARAMETERS = Arrays.asList(DATAZONE_DOMAIN_ID_PARAMETER, DATAZONE_ENVIRONMENT_ID_PARAMETER, DATAZONE_DOMAIN_REGION_PARAMETER, IDENTITY_CENTER_ISSUER_URL_PARAMETER, ConnectionParameters.REGION_PARAMETER);

    @Override
    public String name() {
        return "DataZoneIdc";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        this.validateParameters(parameters, REQUIRED_PARAMETERS, this.name());
        String domainId = (String)DATAZONE_DOMAIN_ID_PARAMETER.findValue(parameters).get();
        String environmentId = (String)DATAZONE_ENVIRONMENT_ID_PARAMETER.findValue(parameters).get();
        String domainRegion = (String)DATAZONE_DOMAIN_REGION_PARAMETER.findValue(parameters).get();
        Region environmentRegion = ConnectionParameters.REGION_PARAMETER.findValue(parameters).get();
        String identityCenterIssuerUrl = IDENTITY_CENTER_ISSUER_URL_PARAMETER.findValue(parameters).get();
        String datazoneEndpoint = DATAZONE_ENDPOINT_OVERRIDE_PARAMETER.findValue(parameters).orElse(null);
        int port = ConnectionParameters.LISTEN_PORT.findValue(parameters).orElse(8000);
        int idpTimeout = ConnectionParameters.IDP_RESPONSE_TIMEOUT.findValue(parameters).orElse(120);
        boolean enableTokenCaching = ConnectionParameters.ENABLE_TOKEN_CACHING_PARAMETER.findValue(parameters).get();
        Server server = new Server(port);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String endpoint = datazoneEndpoint != null ? datazoneEndpoint : DataZoneEndpointUtils.getDataZoneEndpoint(domainRegion);
        Function<AwsCredentialsProvider, DataZoneClient> dataZoneClientFactory = credentialsProvider -> (DataZoneClient)((DataZoneClientBuilder)((DataZoneClientBuilder)((DataZoneClientBuilder)DataZoneClient.builder().credentialsProvider(credentialsProvider)).endpointOverride(URI.create(endpoint))).region(Region.of((String)domainRegion))).build();
        return new DataZoneIdcCredentialsProvider(domainId, environmentId, domainRegion, environmentRegion, datazoneEndpoint, identityCenterIssuerUrl, idpTimeout, enableTokenCaching, new SsoOidcHelper((SsoOidcClient)((SsoOidcClientBuilder)SsoOidcClient.builder().region(Region.of((String)domainRegion))).build(), port, this.getDataZoneScope(datazoneEndpoint)), new DataZoneHelper(domainId, environmentId, domainRegion, endpoint, (HttpClient)httpClient, dataZoneClientFactory), new BrowserControlHelper(System.getProperty("os.name")), server, this.getDataZoneScope(datazoneEndpoint));
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(DATAZONE_DOMAIN_ID_PARAMETER, DATAZONE_ENVIRONMENT_ID_PARAMETER, DATAZONE_DOMAIN_REGION_PARAMETER, IDENTITY_CENTER_ISSUER_URL_PARAMETER, DATAZONE_ENDPOINT_OVERRIDE_PARAMETER, ConnectionParameters.ENABLE_TOKEN_CACHING_PARAMETER, ConnectionParameters.REGION_PARAMETER, ConnectionParameters.LISTEN_PORT, ConnectionParameters.IDP_RESPONSE_TIMEOUT);
    }

    @Override
    protected void validateParameters(Map<ConnectionParameter<?>, String> inputParameters, List<ConnectionParameter<?>> requiredParameters, String credentialsProviderName) {
        super.validateParameters(inputParameters, requiredParameters, credentialsProviderName);
        Optional<Integer> idpTimeout = ConnectionParameters.IDP_RESPONSE_TIMEOUT.findValue(inputParameters);
        if (idpTimeout.isPresent() && idpTimeout.get() < 1) {
            throw new IllegalArgumentException(String.format("Invalid value for IdpResponseTimeout: %s, must be 1 second or longer", idpTimeout.get()));
        }
    }

    private String getDataZoneScope(String datazoneEndpoint) {
        if (datazoneEndpoint == null) {
            return "datazone:domain:access";
        }
        return "datazone_test:domain:access";
    }

    private static Boolean stringToBoolean(String value) {
        if (value != null && (value.equalsIgnoreCase("true") || value.equals("1"))) {
            return true;
        }
        if (value != null && (value.equalsIgnoreCase("false") || value.equals("0"))) {
            return false;
        }
        return null;
    }
}

