/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.oidc;

import com.amazon.athena.jdbc.authentication.http.HttpClientFactory;
import com.amazon.athena.jdbc.cache.Cache;
import com.amazon.athena.jdbc.cache.WellKnownConfigurationCacheEntry;
import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;

public class OpenIdConnectWellKnownConfigurationService {
    private static final AthenaLogger logger = AthenaLogger.of(OpenIdConnectWellKnownConfigurationService.class);
    private static final String AUTHORIZATION_CODE_ENDPOINT = "authorization_endpoint";
    private static final String TOKEN_EXCHANGE_ENDPOINT = "token_endpoint";
    private final Cache<WellKnownConfigurationCacheEntry> wellKnownConfigCache;
    private final HttpClientFactory httpClientFactory;
    private final String openIdConnectWellKnownConfigurationUrl;

    public OpenIdConnectWellKnownConfigurationService(String openIdConnectWellKnownConfigurationUrl, HttpClientFactory httpClientFactory, Cache<WellKnownConfigurationCacheEntry> wellKnownConfigCache) {
        this.wellKnownConfigCache = wellKnownConfigCache;
        this.httpClientFactory = httpClientFactory;
        this.openIdConnectWellKnownConfigurationUrl = openIdConnectWellKnownConfigurationUrl;
    }

    public String getAuthorizationCodeEndpoint() {
        WellKnownConfigurationCacheEntry cacheEntry = this.getWellKnownConfigurationCacheEntry();
        return cacheEntry.getAuthorizationEndpoint();
    }

    public String getTokenEndpoint() {
        WellKnownConfigurationCacheEntry cacheEntry = this.getWellKnownConfigurationCacheEntry();
        return cacheEntry.getTokenEndpoint();
    }

    private WellKnownConfigurationCacheEntry getWellKnownConfigurationCacheEntry() {
        WellKnownConfigurationCacheEntry cacheEntry = this.wellKnownConfigCache.get(this.openIdConnectWellKnownConfigurationUrl).orElse(null);
        if (cacheEntry == null) {
            cacheEntry = this.discoverOidcConfiguration();
            this.wellKnownConfigCache.store(this.openIdConnectWellKnownConfigurationUrl, cacheEntry);
        }
        return cacheEntry;
    }

    /*
     * Exception decompiling
     */
    private WellKnownConfigurationCacheEntry discoverOidcConfiguration() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getIdentityProviderEndpointFromConfiguration(JsonNode openIdConnectStaticInformation, String endpoint) {
        String exceptionMessage = String.format("Missing %s in well-known configuration", endpoint);
        return openIdConnectStaticInformation.field(endpoint).map(JsonNode::text).orElseThrow(() -> new AuthenticationException(exceptionMessage));
    }
}

