/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.utils;

import com.amazon.athena.jdbc.cache.JwtTokenCacheEntry;
import com.amazon.athena.jdbc.support.AuthenticationException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.utils.StringUtils;

public class OpenIdConnectUtils {
    private static final String EXPIRES_IN_FIELD_NAME = "expires_in";

    public static JwtTokenCacheEntry extractTokensFromResponse(String responseBody) {
        JsonNode jsonNode = JsonNodeParser.create().parse(responseBody);
        String idToken = OpenIdConnectUtils.extractField(jsonNode, "id_token").orElseThrow(() -> new AuthenticationException("Missing or empty idToken in response"));
        Optional<String> accessToken = OpenIdConnectUtils.extractField(jsonNode, "access_token");
        Optional<String> tokenType = OpenIdConnectUtils.extractField(jsonNode, "token_type");
        Optional<String> scope = OpenIdConnectUtils.extractField(jsonNode, "scope");
        Optional<String> refreshToken = OpenIdConnectUtils.extractField(jsonNode, "refresh_token");
        long expiresIn = OpenIdConnectUtils.extractExpiresIn(jsonNode);
        Instant expiration = Instant.now().plusSeconds(expiresIn);
        return JwtTokenCacheEntry.builder().idToken(idToken).expiration(expiration).accessToken(accessToken.orElse(null)).tokenType(tokenType.orElse(null)).scope(scope.orElse(null)).refreshToken(refreshToken.orElse(null)).build();
    }

    public static String generateRandomString() {
        byte[] byteArray = new byte[32];
        new SecureRandom().nextBytes(byteArray);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(byteArray);
    }

    public static String generateCodeChallenge(String codeVerifier) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] bytes = digest.digest(codeVerifier.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthenticationException("Failed to generate code challenge", e);
        }
    }

    public static String generateNonce() {
        return UUID.randomUUID().toString();
    }

    private static Optional<String> extractField(JsonNode jsonNode, String fieldName) {
        return jsonNode.field(fieldName).map(JsonNode::text).filter(text -> !StringUtils.isEmpty((CharSequence)text));
    }

    private static long extractExpiresIn(JsonNode jsonNode) {
        return jsonNode.field(EXPIRES_IN_FIELD_NAME).map(node -> {
            try {
                return Long.parseLong(node.text());
            }
            catch (NumberFormatException e) {
                throw new AuthenticationException("Invalid expires_in value in response");
            }
        }).orElseThrow(() -> new AuthenticationException("Missing expires_in in response"));
    }
}

