/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import com.amazon.athena.jdbc.support.sql.WrongNumberOfArgumentsException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

class CotFunction
extends JdbcFunction {
    public CotFunction() {
        super("COT", JdbcFunction.FunctionCategory.NUMERIC, 1);
    }

    @Override
    List<Token> processFunctionCall(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> args = this.processArguments(rawArgs);
        if (args.size() != 1) {
            throw new WrongNumberOfArgumentsException(this.jdbcName, 1, args.size());
        }
        LinkedList<Token> newTokens = new LinkedList<Token>();
        newTokens.add(Token.sql("(1.0 / TAN("));
        newTokens.addAll((Collection)args.get(0));
        newTokens.add(Token.sql("))"));
        return newTokens;
    }
}

