/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import java.util.Arrays;
import java.util.List;

class DateComponentNameFunction
extends JdbcFunction {
    private final String dateFormat;

    DateComponentNameFunction(String jdbcName, String dateFormat) {
        super(jdbcName, "DATE_FORMAT", JdbcFunction.FunctionCategory.TIME_AND_DATE, 1, 1);
        this.dateFormat = dateFormat;
    }

    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<Token> formatArg = Arrays.asList(Token.space(), Token.sql(String.format("'%s'", this.dateFormat)));
        return Arrays.asList(this.toCast(rawArgs.get(0), "DATE"), formatArg);
    }
}

