/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.ConvertFunction;
import com.amazon.athena.jdbc.support.sql.CotFunction;
import com.amazon.athena.jdbc.support.sql.DateCastFunction;
import com.amazon.athena.jdbc.support.sql.DateComponentNameFunction;
import com.amazon.athena.jdbc.support.sql.DayOfWeekFunction;
import com.amazon.athena.jdbc.support.sql.InsertFunction;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.LeftFunction;
import com.amazon.athena.jdbc.support.sql.LengthFunction;
import com.amazon.athena.jdbc.support.sql.LocateFunction;
import com.amazon.athena.jdbc.support.sql.OctetLengthFunction;
import com.amazon.athena.jdbc.support.sql.OperatorFunction;
import com.amazon.athena.jdbc.support.sql.PositionFunction;
import com.amazon.athena.jdbc.support.sql.RandFunction;
import com.amazon.athena.jdbc.support.sql.RepeatFunction;
import com.amazon.athena.jdbc.support.sql.RightFunction;
import com.amazon.athena.jdbc.support.sql.SpaceFunction;
import com.amazon.athena.jdbc.support.sql.SqlTokenizer;
import com.amazon.athena.jdbc.support.sql.SubstringFunction;
import com.amazon.athena.jdbc.support.sql.TimestampCalculationFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import com.amazon.athena.jdbc.support.sql.Unescaper;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class EscapeProcessor {
    static final Map<String, JdbcFunction> FUNCTIONS = new HashMap<String, JdbcFunction>(){
        {
            this.put("ABS", new JdbcFunction("ABS", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("ACOS", new JdbcFunction("ACOS", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("ASIN", new JdbcFunction("ASIN", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("ATAN", new JdbcFunction("ATAN", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("ATAN2", new JdbcFunction("ATAN2", JdbcFunction.FunctionCategory.NUMERIC, 2));
            this.put("CEILING", new JdbcFunction("CEILING", "CEIL", JdbcFunction.FunctionCategory.NUMERIC, 1, 1));
            this.put("CHAR", new JdbcFunction("CHAR", "CHR", JdbcFunction.FunctionCategory.STRING, 1, 1));
            this.put("CHARACTER_LENGTH", new LengthFunction("CHARACTER_LENGTH"));
            this.put("CHAR_LENGTH", new LengthFunction("CHAR_LENGTH"));
            this.put("CONCAT", new JdbcFunction("CONCAT", JdbcFunction.FunctionCategory.STRING, 2));
            this.put("CONVERT", new ConvertFunction());
            this.put("COS", new JdbcFunction("COS", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("COT", new CotFunction());
            this.put("CURDATE", new OperatorFunction("CURDATE", "CURRENT_DATE", JdbcFunction.FunctionCategory.TIME_AND_DATE));
            this.put("CURRENT_DATE", new OperatorFunction("CURRENT_DATE", JdbcFunction.FunctionCategory.TIME_AND_DATE));
            this.put("CURRENT_TIME", new OperatorFunction("CURRENT_TIME", JdbcFunction.FunctionCategory.TIME_AND_DATE));
            this.put("CURRENT_TIMESTAMP", new OperatorFunction("CURRENT_TIMESTAMP", JdbcFunction.FunctionCategory.TIME_AND_DATE));
            this.put("CURTIME", new OperatorFunction("CURTIME", "CURRENT_TIME", JdbcFunction.FunctionCategory.TIME_AND_DATE));
            this.put("DAYNAME", new DateComponentNameFunction("DAYNAME", "%a"));
            this.put("DAYOFMONTH", new DateCastFunction("DAYOFMONTH", "DAY_OF_MONTH"));
            this.put("DAYOFWEEK", new DayOfWeekFunction());
            this.put("DAYOFYEAR", new DateCastFunction("DAYOFYEAR", "DAY_OF_YEAR"));
            this.put("DEGREES", new JdbcFunction("DEGREES", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("EXP", new JdbcFunction("EXP", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("EXTRACT", new JdbcFunction("EXTRACT", JdbcFunction.FunctionCategory.TIME_AND_DATE, 1));
            this.put("FLOOR", new JdbcFunction("FLOOR", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("HOUR", new JdbcFunction("HOUR", JdbcFunction.FunctionCategory.TIME_AND_DATE, 1));
            this.put("IFNULL", new JdbcFunction("IFNULL", "COALESCE", JdbcFunction.FunctionCategory.SYSTEM, 2, 2));
            this.put("INSERT", new InsertFunction());
            this.put("LCASE", new JdbcFunction("LCASE", "LOWER", JdbcFunction.FunctionCategory.STRING, 1, 1));
            this.put("LEFT", new LeftFunction());
            this.put("LENGTH", new LengthFunction("LENGTH"));
            this.put("LOCATE", new LocateFunction());
            this.put("LOG", new JdbcFunction("LOG", "LN", JdbcFunction.FunctionCategory.NUMERIC, 1, 1));
            this.put("LOG10", new JdbcFunction("LOG10", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("LTRIM", new JdbcFunction("LTRIM", JdbcFunction.FunctionCategory.STRING, 1));
            this.put("MINUTE", new JdbcFunction("MINUTE", JdbcFunction.FunctionCategory.TIME_AND_DATE, 1));
            this.put("MOD", new JdbcFunction("MOD", JdbcFunction.FunctionCategory.NUMERIC, 2));
            this.put("MONTH", new JdbcFunction("MONTH", JdbcFunction.FunctionCategory.TIME_AND_DATE, 1));
            this.put("MONTHNAME", new DateComponentNameFunction("MONTHNAME", "%M"));
            this.put("NOW", new JdbcFunction("NOW", JdbcFunction.FunctionCategory.TIME_AND_DATE, 0));
            this.put("OCTET_LENGTH", new OctetLengthFunction());
            this.put("PI", new JdbcFunction("PI", JdbcFunction.FunctionCategory.NUMERIC, 0));
            this.put("POSITION", new PositionFunction());
            this.put("POWER", new JdbcFunction("POWER", JdbcFunction.FunctionCategory.NUMERIC, 2));
            this.put("QUARTER", new JdbcFunction("QUARTER", JdbcFunction.FunctionCategory.TIME_AND_DATE, 1));
            this.put("RADIANS", new JdbcFunction("RADIANS", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("RAND", new RandFunction());
            this.put("REPEAT", new RepeatFunction());
            this.put("REPLACE", new JdbcFunction("REPLACE", JdbcFunction.FunctionCategory.STRING, 3));
            this.put("RIGHT", new RightFunction());
            this.put("ROUND", new JdbcFunction("ROUND", JdbcFunction.FunctionCategory.NUMERIC, 2));
            this.put("RTRIM", new JdbcFunction("RTRIM", JdbcFunction.FunctionCategory.STRING, 1));
            this.put("SECOND", new JdbcFunction("SECOND", JdbcFunction.FunctionCategory.TIME_AND_DATE, 1));
            this.put("SIGN", new JdbcFunction("SIGN", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("SIN", new JdbcFunction("SIN", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("SOUNDEX", new JdbcFunction("SOUNDEX", JdbcFunction.FunctionCategory.STRING, 1));
            this.put("SPACE", new SpaceFunction());
            this.put("SQRT", new JdbcFunction("SQRT", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("SUBSTRING", new SubstringFunction());
            this.put("TAN", new JdbcFunction("TAN", JdbcFunction.FunctionCategory.NUMERIC, 1));
            this.put("TIMESTAMPADD", new TimestampCalculationFunction("TIMESTAMPADD", "DATE_ADD"));
            this.put("TIMESTAMPDIFF", new TimestampCalculationFunction("TIMESTAMPDIFF", "DATE_DIFF"));
            this.put("TRUNCATE", new JdbcFunction("TRUNCATE", "ROUND", JdbcFunction.FunctionCategory.NUMERIC, 2, 2));
            this.put("UCASE", new JdbcFunction("UCASE", "UPPER", JdbcFunction.FunctionCategory.STRING, 1, 1));
            this.put("WEEK", new JdbcFunction("WEEK", JdbcFunction.FunctionCategory.TIME_AND_DATE, 1));
            this.put("YEAR", new JdbcFunction("YEAR", JdbcFunction.FunctionCategory.TIME_AND_DATE, 1));
        }
    };
    private final String sql;

    public EscapeProcessor(String sql) {
        this.sql = sql;
    }

    public static SortedSet<String> numericFunctionNames() {
        return FUNCTIONS.values().stream().filter(f -> f.category() == JdbcFunction.FunctionCategory.NUMERIC).map(JdbcFunction::jdbcName).collect(Collectors.toCollection(TreeSet::new));
    }

    public static SortedSet<String> stringFunctionNames() {
        return FUNCTIONS.values().stream().filter(f -> f.category() == JdbcFunction.FunctionCategory.STRING).map(JdbcFunction::jdbcName).collect(Collectors.toCollection(TreeSet::new));
    }

    public static SortedSet<String> systemFunctionNames() {
        return FUNCTIONS.values().stream().filter(f -> f.category() == JdbcFunction.FunctionCategory.SYSTEM).map(JdbcFunction::jdbcName).collect(Collectors.toCollection(TreeSet::new));
    }

    public static SortedSet<String> timeAndDateFunctionNames() {
        return FUNCTIONS.values().stream().filter(f -> f.category() == JdbcFunction.FunctionCategory.TIME_AND_DATE).map(JdbcFunction::jdbcName).collect(Collectors.toCollection(TreeSet::new));
    }

    public static String unescape(String sql) throws ParseException {
        return new EscapeProcessor(sql).unescape();
    }

    public String unescape() throws ParseException {
        return Unescaper.unescape(SqlTokenizer.tokenize(this.sql)).stream().map(Token::value).collect(Collectors.joining());
    }
}

