/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.AccountSource;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.ResolutionStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccountPoolResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, CreateAccountPoolResponse> {
    private static final SdkField<AccountSource> ACCOUNT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accountSource").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::accountSource)).setter(CreateAccountPoolResponse.setter(Builder::accountSource)).constructor(AccountSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSource").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::createdAt)).setter(CreateAccountPoolResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::createdBy)).setter(CreateAccountPoolResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::description)).setter(CreateAccountPoolResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::domainId)).setter(CreateAccountPoolResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainUnitId").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::domainUnitId)).setter(CreateAccountPoolResponse.setter(Builder::domainUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::id)).setter(CreateAccountPoolResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::lastUpdatedAt)).setter(CreateAccountPoolResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::name)).setter(CreateAccountPoolResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RESOLUTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolutionStrategy").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::resolutionStrategyAsString)).setter(CreateAccountPoolResponse.setter(Builder::resolutionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionStrategy").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(CreateAccountPoolResponse.getter(CreateAccountPoolResponse::updatedBy)).setter(CreateAccountPoolResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SOURCE_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, DOMAIN_UNIT_ID_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, RESOLUTION_STRATEGY_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAccountPoolResponse.memberNameToFieldInitializer();
    private final AccountSource accountSource;
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final String domainUnitId;
    private final String id;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String resolutionStrategy;
    private final String updatedBy;

    private CreateAccountPoolResponse(BuilderImpl builder) {
        super(builder);
        this.accountSource = builder.accountSource;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.domainUnitId = builder.domainUnitId;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.resolutionStrategy = builder.resolutionStrategy;
        this.updatedBy = builder.updatedBy;
    }

    public final AccountSource accountSource() {
        return this.accountSource;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String domainUnitId() {
        return this.domainUnitId;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final ResolutionStrategy resolutionStrategy() {
        return ResolutionStrategy.fromValue(this.resolutionStrategy);
    }

    public final String resolutionStrategyAsString() {
        return this.resolutionStrategy;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountPoolResponse)) {
            return false;
        }
        CreateAccountPoolResponse other = (CreateAccountPoolResponse)((Object)obj);
        return Objects.equals(this.accountSource(), other.accountSource()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainUnitId(), other.domainUnitId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resolutionStrategyAsString(), other.resolutionStrategyAsString()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccountPoolResponse").add("AccountSource", (Object)this.accountSource()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("DomainUnitId", (Object)this.domainUnitId()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ResolutionStrategy", (Object)this.resolutionStrategyAsString()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountSource": {
                return Optional.ofNullable(clazz.cast(this.accountSource()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "domainUnitId": {
                return Optional.ofNullable(clazz.cast(this.domainUnitId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resolutionStrategy": {
                return Optional.ofNullable(clazz.cast(this.resolutionStrategyAsString()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountSource", ACCOUNT_SOURCE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("resolutionStrategy", RESOLUTION_STRATEGY_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountPoolResponse, T> g) {
        return obj -> g.apply((CreateAccountPoolResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private AccountSource accountSource;
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private String domainUnitId;
        private String id;
        private Instant lastUpdatedAt;
        private String name;
        private String resolutionStrategy;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountPoolResponse model) {
            super(model);
            this.accountSource(model.accountSource);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.domainUnitId(model.domainUnitId);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.resolutionStrategy(model.resolutionStrategy);
            this.updatedBy(model.updatedBy);
        }

        public final AccountSource.Builder getAccountSource() {
            return this.accountSource != null ? this.accountSource.toBuilder() : null;
        }

        public final void setAccountSource(AccountSource.BuilderImpl accountSource) {
            this.accountSource = accountSource != null ? accountSource.build() : null;
        }

        @Override
        public final Builder accountSource(AccountSource accountSource) {
            this.accountSource = accountSource;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainUnitId() {
            return this.domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResolutionStrategy() {
            return this.resolutionStrategy;
        }

        public final void setResolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
        }

        @Override
        public final Builder resolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
            return this;
        }

        @Override
        public final Builder resolutionStrategy(ResolutionStrategy resolutionStrategy) {
            this.resolutionStrategy(resolutionStrategy == null ? null : resolutionStrategy.toString());
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public CreateAccountPoolResponse build() {
            return new CreateAccountPoolResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccountPoolResponse> {
        public Builder accountSource(AccountSource var1);

        default public Builder accountSource(Consumer<AccountSource.Builder> accountSource) {
            return this.accountSource((AccountSource)((AccountSource.Builder)AccountSource.builder().applyMutation(accountSource)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder domainUnitId(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder resolutionStrategy(String var1);

        public Builder resolutionStrategy(ResolutionStrategy var1);

        public Builder updatedBy(String var1);
    }
}

