/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.CloudFormationProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisioningProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisioningProperties> {
    private static final SdkField<CloudFormationProperties> CLOUD_FORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudFormation").getter(ProvisioningProperties.getter(ProvisioningProperties::cloudFormation)).setter(ProvisioningProperties.setter(Builder::cloudFormation)).constructor(CloudFormationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProvisioningProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CloudFormationProperties cloudFormation;
    private final Type type;

    private ProvisioningProperties(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
        this.type = builder.type;
    }

    public final CloudFormationProperties cloudFormation() {
        return this.cloudFormation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningProperties)) {
            return false;
        }
        ProvisioningProperties other = (ProvisioningProperties)obj;
        return Objects.equals(this.cloudFormation(), other.cloudFormation());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisioningProperties").add("CloudFormation", (Object)this.cloudFormation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudFormation": {
                return Optional.ofNullable(clazz.cast(this.cloudFormation()));
            }
        }
        return Optional.empty();
    }

    public static ProvisioningProperties fromCloudFormation(CloudFormationProperties cloudFormation) {
        return (ProvisioningProperties)ProvisioningProperties.builder().cloudFormation(cloudFormation).build();
    }

    public static ProvisioningProperties fromCloudFormation(Consumer<CloudFormationProperties.Builder> cloudFormation) {
        CloudFormationProperties.Builder builder = CloudFormationProperties.builder();
        cloudFormation.accept(builder);
        return ProvisioningProperties.fromCloudFormation((CloudFormationProperties)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<CloudFormationProperties>> map = new HashMap<String, SdkField<CloudFormationProperties>>();
        map.put("cloudFormation", CLOUD_FORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningProperties, T> g) {
        return obj -> g.apply((ProvisioningProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudFormationProperties cloudFormation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningProperties model) {
            this.cloudFormation(model.cloudFormation);
        }

        public final CloudFormationProperties.Builder getCloudFormation() {
            return this.cloudFormation != null ? this.cloudFormation.toBuilder() : null;
        }

        public final void setCloudFormation(CloudFormationProperties.BuilderImpl cloudFormation) {
            CloudFormationProperties oldValue = this.cloudFormation;
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
            this.handleUnionValueChange(Type.CLOUD_FORMATION, oldValue, this.cloudFormation);
        }

        @Override
        public final Builder cloudFormation(CloudFormationProperties cloudFormation) {
            CloudFormationProperties oldValue = this.cloudFormation;
            this.cloudFormation = cloudFormation;
            this.handleUnionValueChange(Type.CLOUD_FORMATION, oldValue, this.cloudFormation);
            return this;
        }

        public ProvisioningProperties build() {
            return new ProvisioningProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        CLOUD_FORMATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisioningProperties> {
        public Builder cloudFormation(CloudFormationProperties var1);

        default public Builder cloudFormation(Consumer<CloudFormationProperties.Builder> cloudFormation) {
            return this.cloudFormation((CloudFormationProperties)((CloudFormationProperties.Builder)CloudFormationProperties.builder().applyMutation(cloudFormation)).build());
        }
    }
}

