/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.RedshiftClusterStorage;
import software.amazon.awssdk.services.datazone.model.RedshiftServerlessStorage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftStorage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftStorage> {
    private static final SdkField<RedshiftClusterStorage> REDSHIFT_CLUSTER_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftClusterSource").getter(RedshiftStorage.getter(RedshiftStorage::redshiftClusterSource)).setter(RedshiftStorage.setter(Builder::redshiftClusterSource)).constructor(RedshiftClusterStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftClusterSource").build()}).build();
    private static final SdkField<RedshiftServerlessStorage> REDSHIFT_SERVERLESS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftServerlessSource").getter(RedshiftStorage.getter(RedshiftStorage::redshiftServerlessSource)).setter(RedshiftStorage.setter(Builder::redshiftServerlessSource)).constructor(RedshiftServerlessStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftServerlessSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_CLUSTER_SOURCE_FIELD, REDSHIFT_SERVERLESS_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftStorage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RedshiftClusterStorage redshiftClusterSource;
    private final RedshiftServerlessStorage redshiftServerlessSource;
    private final Type type;

    private RedshiftStorage(BuilderImpl builder) {
        this.redshiftClusterSource = builder.redshiftClusterSource;
        this.redshiftServerlessSource = builder.redshiftServerlessSource;
        this.type = builder.type;
    }

    public final RedshiftClusterStorage redshiftClusterSource() {
        return this.redshiftClusterSource;
    }

    public final RedshiftServerlessStorage redshiftServerlessSource() {
        return this.redshiftServerlessSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftClusterSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftServerlessSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftStorage)) {
            return false;
        }
        RedshiftStorage other = (RedshiftStorage)obj;
        return Objects.equals(this.redshiftClusterSource(), other.redshiftClusterSource()) && Objects.equals(this.redshiftServerlessSource(), other.redshiftServerlessSource());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftStorage").add("RedshiftClusterSource", (Object)this.redshiftClusterSource()).add("RedshiftServerlessSource", (Object)this.redshiftServerlessSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "redshiftClusterSource": {
                return Optional.ofNullable(clazz.cast(this.redshiftClusterSource()));
            }
            case "redshiftServerlessSource": {
                return Optional.ofNullable(clazz.cast(this.redshiftServerlessSource()));
            }
        }
        return Optional.empty();
    }

    public static RedshiftStorage fromRedshiftClusterSource(RedshiftClusterStorage redshiftClusterSource) {
        return (RedshiftStorage)RedshiftStorage.builder().redshiftClusterSource(redshiftClusterSource).build();
    }

    public static RedshiftStorage fromRedshiftClusterSource(Consumer<RedshiftClusterStorage.Builder> redshiftClusterSource) {
        RedshiftClusterStorage.Builder builder = RedshiftClusterStorage.builder();
        redshiftClusterSource.accept(builder);
        return RedshiftStorage.fromRedshiftClusterSource((RedshiftClusterStorage)builder.build());
    }

    public static RedshiftStorage fromRedshiftServerlessSource(RedshiftServerlessStorage redshiftServerlessSource) {
        return (RedshiftStorage)RedshiftStorage.builder().redshiftServerlessSource(redshiftServerlessSource).build();
    }

    public static RedshiftStorage fromRedshiftServerlessSource(Consumer<RedshiftServerlessStorage.Builder> redshiftServerlessSource) {
        RedshiftServerlessStorage.Builder builder = RedshiftServerlessStorage.builder();
        redshiftServerlessSource.accept(builder);
        return RedshiftStorage.fromRedshiftServerlessSource((RedshiftServerlessStorage)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("redshiftClusterSource", REDSHIFT_CLUSTER_SOURCE_FIELD);
        map.put("redshiftServerlessSource", REDSHIFT_SERVERLESS_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftStorage, T> g) {
        return obj -> g.apply((RedshiftStorage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftClusterStorage redshiftClusterSource;
        private RedshiftServerlessStorage redshiftServerlessSource;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftStorage model) {
            this.redshiftClusterSource(model.redshiftClusterSource);
            this.redshiftServerlessSource(model.redshiftServerlessSource);
        }

        public final RedshiftClusterStorage.Builder getRedshiftClusterSource() {
            return this.redshiftClusterSource != null ? this.redshiftClusterSource.toBuilder() : null;
        }

        public final void setRedshiftClusterSource(RedshiftClusterStorage.BuilderImpl redshiftClusterSource) {
            RedshiftClusterStorage oldValue = this.redshiftClusterSource;
            this.redshiftClusterSource = redshiftClusterSource != null ? redshiftClusterSource.build() : null;
            this.handleUnionValueChange(Type.REDSHIFT_CLUSTER_SOURCE, oldValue, this.redshiftClusterSource);
        }

        @Override
        public final Builder redshiftClusterSource(RedshiftClusterStorage redshiftClusterSource) {
            RedshiftClusterStorage oldValue = this.redshiftClusterSource;
            this.redshiftClusterSource = redshiftClusterSource;
            this.handleUnionValueChange(Type.REDSHIFT_CLUSTER_SOURCE, oldValue, this.redshiftClusterSource);
            return this;
        }

        public final RedshiftServerlessStorage.Builder getRedshiftServerlessSource() {
            return this.redshiftServerlessSource != null ? this.redshiftServerlessSource.toBuilder() : null;
        }

        public final void setRedshiftServerlessSource(RedshiftServerlessStorage.BuilderImpl redshiftServerlessSource) {
            RedshiftServerlessStorage oldValue = this.redshiftServerlessSource;
            this.redshiftServerlessSource = redshiftServerlessSource != null ? redshiftServerlessSource.build() : null;
            this.handleUnionValueChange(Type.REDSHIFT_SERVERLESS_SOURCE, oldValue, this.redshiftServerlessSource);
        }

        @Override
        public final Builder redshiftServerlessSource(RedshiftServerlessStorage redshiftServerlessSource) {
            RedshiftServerlessStorage oldValue = this.redshiftServerlessSource;
            this.redshiftServerlessSource = redshiftServerlessSource;
            this.handleUnionValueChange(Type.REDSHIFT_SERVERLESS_SOURCE, oldValue, this.redshiftServerlessSource);
            return this;
        }

        public RedshiftStorage build() {
            return new RedshiftStorage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        REDSHIFT_CLUSTER_SOURCE,
        REDSHIFT_SERVERLESS_SOURCE,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftStorage> {
        public Builder redshiftClusterSource(RedshiftClusterStorage var1);

        default public Builder redshiftClusterSource(Consumer<RedshiftClusterStorage.Builder> redshiftClusterSource) {
            return this.redshiftClusterSource((RedshiftClusterStorage)((RedshiftClusterStorage.Builder)RedshiftClusterStorage.builder().applyMutation(redshiftClusterSource)).build());
        }

        public Builder redshiftServerlessSource(RedshiftServerlessStorage var1);

        default public Builder redshiftServerlessSource(Consumer<RedshiftServerlessStorage.Builder> redshiftServerlessSource) {
            return this.redshiftServerlessSource((RedshiftServerlessStorage)((RedshiftServerlessStorage.Builder)RedshiftServerlessStorage.builder().applyMutation(redshiftServerlessSource)).build());
        }
    }
}

