/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DataTypeConversionFailureHandlingTrait;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.traits.TraitType;

@SdkProtectedApi
public final class SdkField<TypeT> {
    private final String memberName;
    private final MarshallingType<? super TypeT> marshallingType;
    private final MarshallLocation location;
    private final String locationName;
    private final String unmarshallLocationName;
    private final Supplier<SdkPojo> constructor;
    private final BiConsumer<Object, TypeT> setter;
    private final Function<Object, TypeT> getter;
    private final Map<TraitType, Trait> l1Traits;
    private final Map<Class<? extends Trait>, Trait> l2Traits;

    private SdkField(Builder<TypeT> builder) {
        this.memberName = ((Builder)builder).memberName;
        this.marshallingType = ((Builder)builder).marshallingType;
        this.l1Traits = SdkField.createL1Traits(((Builder)builder).traits);
        this.l2Traits = SdkField.createL2Traits(((Builder)builder).traits);
        this.constructor = ((Builder)builder).constructor;
        this.setter = ((Builder)builder).setter;
        this.getter = ((Builder)builder).getter;
        LocationTrait locationTrait = this.getTrait(LocationTrait.class, TraitType.LOCATION_TRAIT);
        this.location = locationTrait.location();
        this.locationName = locationTrait.locationName();
        this.unmarshallLocationName = locationTrait.unmarshallLocationName();
    }

    private static Map<TraitType, Trait> createL1Traits(Map<Class<? extends Trait>, Trait> traits) {
        EnumMap<TraitType, Trait> result = new EnumMap<TraitType, Trait>(TraitType.class);
        for (Map.Entry<Class<? extends Trait>, Trait> kvp : traits.entrySet()) {
            Trait trait = kvp.getValue();
            TraitType type = trait.type();
            if (type == null) continue;
            result.put(type, trait);
        }
        return result;
    }

    private static Map<Class<? extends Trait>, Trait> createL2Traits(Map<Class<? extends Trait>, Trait> traits) {
        HashMap<Class<? extends Trait>, Trait> result = new HashMap<Class<? extends Trait>, Trait>();
        for (Map.Entry<Class<? extends Trait>, Trait> kvp : traits.entrySet()) {
            Trait trait = kvp.getValue();
            TraitType type = trait.type();
            if (type != null) continue;
            result.put(kvp.getKey(), trait);
        }
        return result;
    }

    public String memberName() {
        return this.memberName;
    }

    public MarshallingType<? super TypeT> marshallingType() {
        return this.marshallingType;
    }

    public MarshallLocation location() {
        return this.location;
    }

    public String locationName() {
        return this.locationName;
    }

    public boolean ignoreDataTypeConversionFailures() {
        DataTypeConversionFailureHandlingTrait dataTypeConversionFailureHandlingTrait = this.getTrait(DataTypeConversionFailureHandlingTrait.class, TraitType.DATA_TYPE_CONVERSION_FAILURE_HANDLING_TRAIT);
        return dataTypeConversionFailureHandlingTrait != null;
    }

    public String unmarshallLocationName() {
        return this.unmarshallLocationName;
    }

    public Supplier<SdkPojo> constructor() {
        return this.constructor;
    }

    public <T extends Trait> T getTrait(Class<T> clzz) {
        TraitType type = TraitType.from(clzz);
        if (type != null) {
            return (T)this.l1Traits.get((Object)type);
        }
        return (T)this.l2Traits.get(clzz);
    }

    public <T extends Trait> T getTrait(Class<T> clzz, TraitType type) {
        return (T)this.l1Traits.get((Object)type);
    }

    public <T extends Trait> Optional<T> getOptionalTrait(Class<T> clzz) {
        return Optional.ofNullable(this.getTrait(clzz));
    }

    public <T extends Trait> Optional<T> getOptionalTrait(Class<T> clzz, TraitType type) {
        return Optional.ofNullable(this.getTrait(clzz, type));
    }

    public <T extends Trait> T getRequiredTrait(Class<T> clzz) throws IllegalStateException {
        T trait = this.getTrait(clzz);
        if (trait == null) {
            throw new IllegalStateException(this.memberName + " member is missing " + clzz.getSimpleName());
        }
        return trait;
    }

    public <T extends Trait> T getRequiredTrait(Class<T> clzz, TraitType type) throws IllegalStateException {
        T trait = this.getTrait(clzz, type);
        if (trait == null) {
            throw new IllegalStateException(this.memberName + " member is missing " + clzz.getSimpleName());
        }
        return trait;
    }

    public boolean containsTrait(Class<? extends Trait> clzz) {
        return this.getTrait(clzz) != null;
    }

    public boolean containsTrait(Class<? extends Trait> clzz, TraitType type) {
        return this.getTrait(clzz, type) != null;
    }

    private TypeT get(Object pojo) {
        return this.getter.apply(pojo);
    }

    public TypeT getValueOrDefault(Object pojo) {
        TypeT val = this.get(pojo);
        DefaultValueTrait trait = this.getTrait(DefaultValueTrait.class, TraitType.DEFAULT_VALUE_TRAIT);
        return (TypeT)(trait == null ? val : trait.resolveValue(val));
    }

    public void set(Object pojo, Object val) {
        this.setter.accept(pojo, val);
    }

    public static <TypeT> Builder<TypeT> builder(MarshallingType<? super TypeT> marshallingType) {
        return new Builder(marshallingType);
    }

    public static final class Builder<TypeT> {
        private final MarshallingType<? super TypeT> marshallingType;
        private String memberName;
        private Supplier<SdkPojo> constructor;
        private BiConsumer<Object, TypeT> setter;
        private Function<Object, TypeT> getter;
        private final Map<Class<? extends Trait>, Trait> traits = new HashMap<Class<? extends Trait>, Trait>();

        private Builder(MarshallingType<? super TypeT> marshallingType) {
            this.marshallingType = marshallingType;
        }

        public Builder<TypeT> memberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public Builder<TypeT> constructor(Supplier<SdkPojo> constructor) {
            this.constructor = constructor;
            return this;
        }

        public Builder<TypeT> setter(BiConsumer<Object, TypeT> setter) {
            this.setter = setter;
            return this;
        }

        public Builder<TypeT> getter(Function<Object, TypeT> getter) {
            this.getter = getter;
            return this;
        }

        public Builder<TypeT> traits(Trait ... traits) {
            Arrays.stream(traits).forEach(t -> this.traits.put((Class<? extends Trait>)t.getClass(), (Trait)t));
            return this;
        }

        public SdkField<TypeT> build() {
            return new SdkField(this);
        }
    }
}

