/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.client.builder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.CompressionConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.internal.http.loader.DefaultSdkAsyncHttpClientBuilder;
import software.amazon.awssdk.core.internal.http.loader.DefaultSdkHttpClientBuilder;
import software.amazon.awssdk.core.internal.interceptor.HttpChecksumValidationInterceptor;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetryStrategy;
import software.amazon.awssdk.core.internal.useragent.AppIdResolver;
import software.amazon.awssdk.core.internal.useragent.SdkClientUserAgentProperties;
import software.amazon.awssdk.core.internal.useragent.SdkUserAgentBuilder;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.util.SystemUserAgent;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.OptionalUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkProtectedApi
public abstract class SdkDefaultClientBuilder<B extends SdkClientBuilder<B, C>, C>
implements SdkClientBuilder<B, C> {
    private static final SdkHttpClient.Builder DEFAULT_HTTP_CLIENT_BUILDER = new DefaultSdkHttpClientBuilder();
    private static final SdkAsyncHttpClient.Builder DEFAULT_ASYNC_HTTP_CLIENT_BUILDER = new DefaultSdkAsyncHttpClientBuilder();
    protected final SdkClientConfiguration.Builder clientConfiguration = SdkClientConfiguration.builder();
    protected final AttributeMap.Builder clientContextParams = AttributeMap.builder();
    protected ClientOverrideConfiguration overrideConfig;
    private final SdkHttpClient.Builder defaultHttpClientBuilder;
    private final SdkAsyncHttpClient.Builder defaultAsyncHttpClientBuilder;
    private final List<SdkPlugin> plugins = new ArrayList<SdkPlugin>();

    protected SdkDefaultClientBuilder() {
        this(DEFAULT_HTTP_CLIENT_BUILDER, DEFAULT_ASYNC_HTTP_CLIENT_BUILDER);
    }

    @SdkTestInternalApi
    protected SdkDefaultClientBuilder(SdkHttpClient.Builder defaultHttpClientBuilder, SdkAsyncHttpClient.Builder defaultAsyncHttpClientBuilder) {
        this.defaultHttpClientBuilder = defaultHttpClientBuilder;
        this.defaultAsyncHttpClientBuilder = defaultAsyncHttpClientBuilder;
    }

    public final C build() {
        return this.buildClient();
    }

    protected abstract C buildClient();

    protected final SdkClientConfiguration syncClientConfiguration() {
        this.clientConfiguration.option(SdkClientOption.CLIENT_CONTEXT_PARAMS, this.clientContextParams.build());
        SdkClientConfiguration configuration = this.clientConfiguration.build();
        configuration = this.setOverrides(configuration);
        configuration = this.mergeChildDefaults(configuration);
        configuration = this.mergeGlobalDefaults(configuration);
        configuration = this.finalizeChildConfiguration(configuration);
        configuration = this.finalizeSyncConfiguration(configuration);
        configuration = this.finalizeConfiguration(configuration);
        configuration = this.invokePlugins(configuration);
        return configuration;
    }

    protected final SdkClientConfiguration asyncClientConfiguration() {
        this.clientConfiguration.option(SdkClientOption.CLIENT_CONTEXT_PARAMS, this.clientContextParams.build());
        SdkClientConfiguration configuration = this.clientConfiguration.build();
        configuration = this.setOverrides(configuration);
        configuration = this.mergeChildDefaults(configuration);
        configuration = this.mergeGlobalDefaults(configuration);
        configuration = this.finalizeChildConfiguration(configuration);
        configuration = this.finalizeAsyncConfiguration(configuration);
        configuration = this.finalizeConfiguration(configuration);
        configuration = this.invokePlugins(configuration);
        return configuration;
    }

    protected SdkClientConfiguration setOverrides(SdkClientConfiguration configuration) {
        if (this.overrideConfig == null) {
            return configuration;
        }
        SdkClientConfiguration.Builder builder = configuration.toBuilder();
        this.overrideConfig.retryStrategy().ifPresent(retryStrategy -> builder.option(SdkClientOption.RETRY_STRATEGY, retryStrategy));
        this.overrideConfig.retryMode().ifPresent(retryMode -> builder.option(SdkClientOption.RETRY_STRATEGY, SdkDefaultRetryStrategy.forRetryMode(retryMode)));
        this.overrideConfig.retryStrategyConfigurator().ifPresent(configurator -> {
            RetryStrategy.Builder defaultBuilder = SdkDefaultRetryStrategy.defaultRetryStrategy().toBuilder();
            configurator.accept(defaultBuilder);
            builder.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
        });
        builder.putAll(this.overrideConfig);
        builder.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        builder.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        builder.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
        return builder.build();
    }

    protected SdkClientConfiguration mergeChildDefaults(SdkClientConfiguration configuration) {
        return configuration;
    }

    private SdkClientConfiguration mergeGlobalDefaults(SdkClientConfiguration configuration) {
        Supplier<ProfileFile> defaultProfileFileSupplier = () -> ((Lazy)new Lazy(ProfileFile::defaultProfileFile)).getValue();
        configuration = configuration.merge(c -> c.option(SdkClientOption.EXECUTION_INTERCEPTORS, new ArrayList()).option(SdkClientOption.METRIC_PUBLISHERS, new ArrayList()).option(SdkClientOption.ADDITIONAL_HTTP_HEADERS, new LinkedHashMap()).option(SdkClientOption.PROFILE_FILE_SUPPLIER, defaultProfileFileSupplier).lazyOption(SdkClientOption.PROFILE_FILE, conf -> (ProfileFile)((Supplier)conf.get(SdkClientOption.PROFILE_FILE_SUPPLIER)).get()).option(SdkClientOption.PROFILE_NAME, ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow()).option(SdkAdvancedClientOption.USER_AGENT_PREFIX, "").option(SdkAdvancedClientOption.USER_AGENT_SUFFIX, "").option(SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, false).option(SdkClientOption.CONFIGURED_COMPRESSION_CONFIGURATION, (CompressionConfiguration)CompressionConfiguration.builder().build()));
        return configuration;
    }

    protected SdkClientConfiguration finalizeChildConfiguration(SdkClientConfiguration configuration) {
        return configuration;
    }

    private SdkClientConfiguration finalizeSyncConfiguration(SdkClientConfiguration config) {
        return config.toBuilder().lazyOption(SdkClientOption.SYNC_HTTP_CLIENT, c -> this.resolveSyncHttpClient(c, config)).option(SdkClientOption.CLIENT_TYPE, ClientType.SYNC).build();
    }

    private SdkClientConfiguration finalizeAsyncConfiguration(SdkClientConfiguration config) {
        return config.toBuilder().lazyOptionIfAbsent(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, this::resolveAsyncFutureCompletionExecutor).lazyOption(SdkClientOption.ASYNC_HTTP_CLIENT, c -> this.resolveAsyncHttpClient(c, config)).option(SdkClientOption.CLIENT_TYPE, ClientType.ASYNC).build();
    }

    private SdkClientConfiguration finalizeConfiguration(SdkClientConfiguration config) {
        return config.toBuilder().lazyOption(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE, this::resolveScheduledExecutorService).lazyOptionIfAbsent(SdkClientOption.RETRY_STRATEGY, this::resolveRetryStrategy).option(SdkClientOption.EXECUTION_INTERCEPTORS, this.resolveExecutionInterceptors(config)).lazyOption(SdkClientOption.CLIENT_USER_AGENT, this::resolveClientUserAgent).lazyOption(SdkClientOption.COMPRESSION_CONFIGURATION, this::resolveCompressionConfiguration).lazyOptionIfAbsent(SdkClientOption.IDENTITY_PROVIDERS, c -> (IdentityProviders)IdentityProviders.builder().build()).build();
    }

    private CompressionConfiguration resolveCompressionConfiguration(AttributeMap.LazyValueSource config) {
        CompressionConfiguration compressionConfig = (CompressionConfiguration)config.get(SdkClientOption.CONFIGURED_COMPRESSION_CONFIGURATION);
        return (CompressionConfiguration)compressionConfig.toBuilder().requestCompressionEnabled(this.resolveCompressionEnabled(config, compressionConfig)).minimumCompressionThresholdInBytes(this.resolveMinCompressionThreshold(config, compressionConfig)).build();
    }

    private Boolean resolveCompressionEnabled(AttributeMap.LazyValueSource config, CompressionConfiguration compressionConfig) {
        Supplier<Optional> systemSettingConfiguration = () -> SdkSystemSetting.AWS_DISABLE_REQUEST_COMPRESSION.getBooleanValue().map(v -> v == false);
        Supplier<Optional> profileFileConfiguration = () -> ((ProfileFile)((Supplier)config.get(SdkClientOption.PROFILE_FILE_SUPPLIER)).get()).profile((String)config.get(SdkClientOption.PROFILE_NAME)).flatMap(p -> p.booleanProperty("disable_request_compression")).map(v -> v == false);
        return OptionalUtils.firstPresent(Optional.ofNullable(compressionConfig.requestCompressionEnabled()), (Supplier[])new Supplier[]{systemSettingConfiguration, profileFileConfiguration}).orElse(true);
    }

    private Integer resolveMinCompressionThreshold(AttributeMap.LazyValueSource config, CompressionConfiguration compressionConfig) {
        Supplier<Optional> systemSettingConfiguration = () -> ((SdkSystemSetting)SdkSystemSetting.AWS_REQUEST_MIN_COMPRESSION_SIZE_BYTES).getIntegerValue();
        Supplier<Optional> profileFileConfiguration = () -> ((ProfileFile)((Supplier)config.get(SdkClientOption.PROFILE_FILE_SUPPLIER)).get()).profile((String)config.get(SdkClientOption.PROFILE_NAME)).flatMap(p -> p.property("request_min_compression_size_bytes")).map(Integer::parseInt);
        return OptionalUtils.firstPresent(Optional.ofNullable(compressionConfig.minimumCompressionThresholdInBytes()), (Supplier[])new Supplier[]{systemSettingConfiguration, profileFileConfiguration}).orElse(10240);
    }

    @SdkPreviewApi
    protected SdkClientConfiguration invokePlugins(SdkClientConfiguration config) {
        return config;
    }

    private String resolveClientUserAgent(AttributeMap.LazyValueSource config) {
        SdkClientUserAgentProperties clientProperties = new SdkClientUserAgentProperties();
        ClientType clientType = (ClientType)((Object)config.get(SdkClientOption.CLIENT_TYPE));
        ClientType resolvedClientType = clientType == null ? ClientType.UNKNOWN : clientType;
        clientProperties.putProperty("internal", StringUtils.trimToEmpty((String)((String)config.get(SdkClientOption.INTERNAL_USER_AGENT))));
        clientProperties.putProperty("io", StringUtils.lowerCase((String)resolvedClientType.name()));
        clientProperties.putProperty("http", SdkHttpUtils.urlEncode((String)SdkDefaultClientBuilder.clientName(resolvedClientType, (SdkHttpClient)config.get(SdkClientOption.SYNC_HTTP_CLIENT), (SdkAsyncHttpClient)config.get(SdkClientOption.ASYNC_HTTP_CLIENT))));
        String appId = (String)config.get(SdkClientOption.USER_AGENT_APP_ID);
        String resolvedAppId = appId == null ? this.resolveAppId(config) : appId;
        clientProperties.putProperty("app", resolvedAppId);
        clientProperties.putProperty("api", (String)config.get(SdkClientOption.API_METADATA));
        return SdkUserAgentBuilder.buildClientUserAgentString(SystemUserAgent.getOrCreate(), clientProperties);
    }

    private String resolveAppId(AttributeMap.LazyValueSource config) {
        Optional<String> appIdFromConfig = AppIdResolver.create().profileFile((Supplier)config.get(SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName((String)config.get(SdkClientOption.PROFILE_NAME)).resolve();
        return appIdFromConfig.orElse(null);
    }

    private static String clientName(ClientType clientType, SdkHttpClient syncHttpClient, SdkAsyncHttpClient asyncHttpClient) {
        if (clientType == ClientType.SYNC) {
            return syncHttpClient == null ? "null" : syncHttpClient.clientName();
        }
        if (clientType == ClientType.ASYNC) {
            return asyncHttpClient == null ? "null" : asyncHttpClient.clientName();
        }
        return ClientType.UNKNOWN.name();
    }

    private RetryStrategy resolveRetryStrategy(AttributeMap.LazyValueSource config) {
        RetryMode retryMode = RetryMode.resolver().profileFile((Supplier)config.get(SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName((String)config.get(SdkClientOption.PROFILE_NAME)).defaultRetryMode((RetryMode)((Object)config.get(SdkClientOption.DEFAULT_RETRY_MODE))).resolve();
        return SdkDefaultRetryStrategy.forRetryMode(retryMode);
    }

    private SdkHttpClient resolveSyncHttpClient(AttributeMap.LazyValueSource config, SdkClientConfiguration deprecatedConfigDoNotUseThis) {
        SdkHttpClient httpClient = (SdkHttpClient)config.get(SdkClientOption.CONFIGURED_SYNC_HTTP_CLIENT);
        SdkHttpClient.Builder httpClientBuilder = (SdkHttpClient.Builder)config.get(SdkClientOption.CONFIGURED_SYNC_HTTP_CLIENT_BUILDER);
        Validate.isTrue((httpClient == null || httpClientBuilder == null ? 1 : 0) != 0, (String)"The httpClient and the httpClientBuilder can't both be configured.", (Object[])new Object[0]);
        AttributeMap httpClientConfig = this.getHttpClientConfig(config, deprecatedConfigDoNotUseThis);
        return Either.fromNullable((Object)httpClient, (Object)httpClientBuilder).map(e -> (SdkHttpClient)e.map(Function.identity(), b -> b.buildWithDefaults(httpClientConfig))).orElseGet(() -> this.defaultHttpClientBuilder.buildWithDefaults(httpClientConfig));
    }

    private SdkAsyncHttpClient resolveAsyncHttpClient(AttributeMap.LazyValueSource config, SdkClientConfiguration deprecatedConfigDoNotUseThis) {
        Validate.isTrue((config.get(SdkClientOption.CONFIGURED_ASYNC_HTTP_CLIENT) == null || config.get(SdkClientOption.CONFIGURED_ASYNC_HTTP_CLIENT_BUILDER) == null ? 1 : 0) != 0, (String)"The asyncHttpClient and the asyncHttpClientBuilder can't both be configured.", (Object[])new Object[0]);
        AttributeMap httpClientConfig = this.getHttpClientConfig(config, deprecatedConfigDoNotUseThis);
        return Either.fromNullable((Object)((SdkAsyncHttpClient)config.get(SdkClientOption.CONFIGURED_ASYNC_HTTP_CLIENT)), (Object)((SdkAsyncHttpClient.Builder)config.get(SdkClientOption.CONFIGURED_ASYNC_HTTP_CLIENT_BUILDER))).map(e -> (SdkAsyncHttpClient)e.map(Function.identity(), b -> b.buildWithDefaults(httpClientConfig))).orElseGet(() -> this.defaultAsyncHttpClientBuilder.buildWithDefaults(httpClientConfig));
    }

    private AttributeMap getHttpClientConfig(AttributeMap.LazyValueSource config, SdkClientConfiguration deprecatedConfigDoNotUseThis) {
        AttributeMap httpClientConfig = (AttributeMap)config.get(SdkClientOption.HTTP_CLIENT_CONFIG);
        if (httpClientConfig == null) {
            httpClientConfig = this.childHttpConfig(deprecatedConfigDoNotUseThis);
        }
        return httpClientConfig;
    }

    @Deprecated
    protected AttributeMap childHttpConfig(SdkClientConfiguration configuration) {
        return this.childHttpConfig();
    }

    @Deprecated
    protected AttributeMap childHttpConfig() {
        return AttributeMap.empty();
    }

    private Executor resolveAsyncFutureCompletionExecutor(AttributeMap.LazyValueSource config) {
        int processors = Runtime.getRuntime().availableProcessors();
        int corePoolSize = Math.max(8, processors);
        int maxPoolSize = Math.max(64, processors * 2);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().threadNamePrefix("sdk-async-response").build());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private ScheduledExecutorService resolveScheduledExecutorService(AttributeMap.LazyValueSource c) {
        ScheduledExecutorService executor = (ScheduledExecutorService)c.get(SdkClientOption.CONFIGURED_SCHEDULED_EXECUTOR_SERVICE);
        if (executor != null) {
            return executor;
        }
        return Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().threadNamePrefix("sdk-ScheduledExecutor").build());
    }

    private List<ExecutionInterceptor> resolveExecutionInterceptors(SdkClientConfiguration config) {
        ArrayList<ExecutionInterceptor> globalInterceptors = new ArrayList<ExecutionInterceptor>();
        globalInterceptors.addAll(this.sdkInterceptors());
        globalInterceptors.addAll(new ClasspathInterceptorChainFactory().getGlobalInterceptors());
        return CollectionUtils.mergeLists(globalInterceptors, config.option(SdkClientOption.EXECUTION_INTERCEPTORS));
    }

    private List<ExecutionInterceptor> sdkInterceptors() {
        return Collections.unmodifiableList(Arrays.asList(new HttpChecksumValidationInterceptor()));
    }

    @Override
    public final B endpointOverride(URI endpointOverride) {
        if (endpointOverride == null) {
            this.clientConfiguration.option(SdkClientOption.CLIENT_ENDPOINT_PROVIDER, null);
        } else {
            this.clientConfiguration.option(SdkClientOption.CLIENT_ENDPOINT_PROVIDER, ClientEndpointProvider.forEndpointOverride(endpointOverride));
        }
        return this.thisBuilder();
    }

    public final void setEndpointOverride(URI endpointOverride) {
        this.endpointOverride(endpointOverride);
    }

    public final B asyncConfiguration(ClientAsyncConfiguration asyncConfiguration) {
        this.clientConfiguration.option(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, asyncConfiguration.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR));
        return this.thisBuilder();
    }

    public final void setAsyncConfiguration(ClientAsyncConfiguration asyncConfiguration) {
        this.asyncConfiguration(asyncConfiguration);
    }

    @Override
    public final B overrideConfiguration(ClientOverrideConfiguration overrideConfig) {
        this.overrideConfig = overrideConfig;
        return this.thisBuilder();
    }

    public final void setOverrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.overrideConfiguration(overrideConfiguration);
    }

    @Override
    public final ClientOverrideConfiguration overrideConfiguration() {
        if (this.overrideConfig == null) {
            return (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().build();
        }
        return this.overrideConfig;
    }

    public final B httpClient(SdkHttpClient httpClient) {
        if (httpClient != null) {
            httpClient = new NonManagedSdkHttpClient(httpClient);
        }
        this.clientConfiguration.option(SdkClientOption.CONFIGURED_SYNC_HTTP_CLIENT, httpClient);
        return this.thisBuilder();
    }

    public final B httpClientBuilder(SdkHttpClient.Builder httpClientBuilder) {
        this.clientConfiguration.option(SdkClientOption.CONFIGURED_SYNC_HTTP_CLIENT_BUILDER, httpClientBuilder);
        return this.thisBuilder();
    }

    public final B httpClient(SdkAsyncHttpClient httpClient) {
        if (httpClient != null) {
            httpClient = new NonManagedSdkAsyncHttpClient(httpClient);
        }
        this.clientConfiguration.option(SdkClientOption.CONFIGURED_ASYNC_HTTP_CLIENT, httpClient);
        return this.thisBuilder();
    }

    public final B httpClientBuilder(SdkAsyncHttpClient.Builder httpClientBuilder) {
        this.clientConfiguration.option(SdkClientOption.CONFIGURED_ASYNC_HTTP_CLIENT_BUILDER, httpClientBuilder);
        return this.thisBuilder();
    }

    public final B metricPublishers(List<MetricPublisher> metricPublishers) {
        this.clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS, metricPublishers);
        return this.thisBuilder();
    }

    @Override
    public final B addPlugin(SdkPlugin plugin) {
        this.plugins.add((SdkPlugin)Validate.paramNotNull((Object)plugin, (String)"plugin"));
        return this.thisBuilder();
    }

    @Override
    public final List<SdkPlugin> plugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    protected B thisBuilder() {
        return (B)this;
    }

    @SdkTestInternalApi
    public static final class NonManagedSdkHttpClient
    implements SdkHttpClient {
        private final SdkHttpClient delegate;

        private NonManagedSdkHttpClient(SdkHttpClient delegate) {
            this.delegate = (SdkHttpClient)Validate.paramNotNull((Object)delegate, (String)"SdkHttpClient");
        }

        public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
            return this.delegate.prepareRequest(request);
        }

        public void close() {
        }

        public String clientName() {
            return this.delegate.clientName();
        }
    }

    @SdkTestInternalApi
    public static final class NonManagedSdkAsyncHttpClient
    implements SdkAsyncHttpClient {
        private final SdkAsyncHttpClient delegate;

        NonManagedSdkAsyncHttpClient(SdkAsyncHttpClient delegate) {
            this.delegate = (SdkAsyncHttpClient)Validate.paramNotNull((Object)delegate, (String)"SdkAsyncHttpClient");
        }

        public CompletableFuture<Void> execute(AsyncExecuteRequest request) {
            return this.delegate.execute(request);
        }

        public String clientName() {
            return this.delegate.clientName();
        }

        public void close() {
        }
    }
}

