/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.client.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ToBuilderIgnoreField;
import software.amazon.awssdk.core.CompressionConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSupplier;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ScheduledExecutorUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ClientOverrideConfiguration
implements ToCopyableBuilder<Builder, ClientOverrideConfiguration> {
    private static final Set<ClientOption<?>> CLIENT_OVERRIDE_OPTIONS;
    private static final Set<ClientOption<?>> RESOLVED_OPTIONS;
    private final SdkClientConfiguration config;
    private final SdkClientConfiguration resolvedConfig;
    private final Map<String, List<String>> headers;
    private final List<ExecutionInterceptor> executionInterceptors;
    private final List<MetricPublisher> metricPublishers;
    private final ExecutionAttributes executionAttributes;

    @SdkInternalApi
    ClientOverrideConfiguration(SdkClientConfiguration config, SdkClientConfiguration resolvedConfig) {
        this.config = config;
        this.resolvedConfig = resolvedConfig;
        Map<String, List<String>> headers = config.option(SdkClientOption.ADDITIONAL_HTTP_HEADERS);
        this.headers = headers == null ? Collections.emptyMap() : CollectionUtils.deepUnmodifiableMap(headers, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        List<ExecutionInterceptor> interceptors = config.option(SdkClientOption.EXECUTION_INTERCEPTORS);
        this.executionInterceptors = interceptors == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ExecutionInterceptor>(interceptors));
        List<MetricPublisher> metricPublishers = config.option(SdkClientOption.METRIC_PUBLISHERS);
        this.metricPublishers = metricPublishers == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<MetricPublisher>(metricPublishers));
        ExecutionAttributes executionAttributes = config.option(SdkClientOption.EXECUTION_ATTRIBUTES);
        this.executionAttributes = executionAttributes == null ? new ExecutionAttributes() : ExecutionAttributes.unmodifiableExecutionAttributes(executionAttributes);
        Validate.isPositiveOrNull((Duration)this.apiCallTimeout().orElse(null), (String)"apiCallTimeout");
        Validate.isPositiveOrNull((Duration)this.apiCallAttemptTimeout().orElse(null), (String)"apiCallAttemptTimeout");
    }

    @ToBuilderIgnoreField(value={"config", "resolvedConfig"})
    public Builder toBuilder() {
        return new DefaultBuilder(this.config.toBuilder(), this.resolvedConfig.toBuilder()).headers(this.headers).executionInterceptors(this.executionInterceptors).executionAttributes(this.executionAttributes).metricPublishers(this.metricPublishers);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    @SdkInternalApi
    SdkClientConfiguration asSdkClientConfiguration() {
        return this.config;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<RetryPolicy> retryPolicy() {
        return Optional.ofNullable(this.config.option(SdkClientOption.RETRY_POLICY));
    }

    public Optional<RetryStrategy> retryStrategy() {
        RetryStrategy configured = this.config.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY);
        if (configured != null) {
            return Optional.of(configured);
        }
        return Optional.ofNullable(this.config.option(SdkClientOption.RETRY_STRATEGY));
    }

    public Optional<Consumer<RetryStrategy.Builder<?, ?>>> retryStrategyConfigurator() {
        return Optional.ofNullable(this.config.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR));
    }

    public Optional<RetryMode> retryMode() {
        return Optional.ofNullable(this.config.option(SdkClientOption.CONFIGURED_RETRY_MODE));
    }

    public <T> Optional<T> advancedOption(SdkAdvancedClientOption<T> option) {
        return Optional.ofNullable(this.config.option(option));
    }

    public List<ExecutionInterceptor> executionInterceptors() {
        return this.executionInterceptors;
    }

    public Optional<ScheduledExecutorService> scheduledExecutorService() {
        ScheduledExecutorService scheduledExecutorService = this.resolvedConfig.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
        if (scheduledExecutorService == null) {
            scheduledExecutorService = ScheduledExecutorUtils.unwrapUnmanagedScheduledExecutor((ScheduledExecutorService)this.config.option(SdkClientOption.CONFIGURED_SCHEDULED_EXECUTOR_SERVICE));
        }
        return Optional.ofNullable(scheduledExecutorService);
    }

    public Optional<Duration> apiCallTimeout() {
        return Optional.ofNullable(this.config.option(SdkClientOption.API_CALL_TIMEOUT));
    }

    public Optional<Duration> apiCallAttemptTimeout() {
        return Optional.ofNullable(this.config.option(SdkClientOption.API_CALL_ATTEMPT_TIMEOUT));
    }

    public Optional<Supplier<ProfileFile>> defaultProfileFileSupplier() {
        return Optional.ofNullable(this.config.option(SdkClientOption.PROFILE_FILE_SUPPLIER));
    }

    public Optional<ProfileFile> defaultProfileFile() {
        return Optional.ofNullable(this.config.option(SdkClientOption.PROFILE_FILE_SUPPLIER)).map(Supplier::get);
    }

    public Optional<String> defaultProfileName() {
        return Optional.ofNullable(this.config.option(SdkClientOption.PROFILE_NAME));
    }

    public List<MetricPublisher> metricPublishers() {
        return this.metricPublishers;
    }

    public ExecutionAttributes executionAttributes() {
        return this.executionAttributes;
    }

    public Optional<CompressionConfiguration> compressionConfiguration() {
        CompressionConfiguration compressionConfig = this.resolvedConfig.option(SdkClientOption.COMPRESSION_CONFIGURATION);
        if (compressionConfig == null) {
            compressionConfig = this.config.option(SdkClientOption.CONFIGURED_COMPRESSION_CONFIGURATION);
        }
        return Optional.ofNullable(compressionConfig);
    }

    public Optional<String> appId() {
        return Optional.ofNullable(this.config.option(SdkClientOption.USER_AGENT_APP_ID));
    }

    public String toString() {
        return ToString.builder((String)"ClientOverrideConfiguration").add("headers", this.headers()).add("retryPolicy", this.retryPolicy().orElse(null)).add("retryStrategy", this.retryStrategy().orElse(null)).add("apiCallTimeout", this.apiCallTimeout().orElse(null)).add("apiCallAttemptTimeout", this.apiCallAttemptTimeout().orElse(null)).add("executionInterceptors", this.executionInterceptors()).add("profileFileSupplier", this.defaultProfileFileSupplier().orElse(null)).add("profileFile", this.defaultProfileFile().orElse(null)).add("profileName", this.defaultProfileName().orElse(null)).add("scheduledExecutorService", this.scheduledExecutorService().orElse(null)).add("compressionConfiguration", this.compressionConfiguration().orElse(null)).add("appId", this.appId().orElse(null)).build();
    }

    static {
        HashSet<SdkClientOption<Object>> options = new HashSet<SdkClientOption<Object>>();
        options.add(SdkClientOption.ADDITIONAL_HTTP_HEADERS);
        options.add(SdkClientOption.EXECUTION_INTERCEPTORS);
        options.add(SdkClientOption.METRIC_PUBLISHERS);
        options.add(SdkClientOption.EXECUTION_ATTRIBUTES);
        options.add(SdkClientOption.CONFIGURED_COMPRESSION_CONFIGURATION);
        options.add(SdkClientOption.CONFIGURED_SCHEDULED_EXECUTOR_SERVICE);
        options.add(SdkClientOption.RETRY_POLICY);
        options.add(SdkClientOption.RETRY_STRATEGY);
        options.add(SdkClientOption.API_CALL_TIMEOUT);
        options.add(SdkClientOption.API_CALL_ATTEMPT_TIMEOUT);
        options.add(SdkClientOption.PROFILE_FILE_SUPPLIER);
        options.add(SdkClientOption.PROFILE_NAME);
        options.add(SdkClientOption.CONFIGURED_RETRY_STRATEGY);
        options.add(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR);
        options.add(SdkClientOption.CONFIGURED_RETRY_MODE);
        options.add(SdkClientOption.USER_AGENT_APP_ID);
        CLIENT_OVERRIDE_OPTIONS = Collections.unmodifiableSet(options);
        HashSet<SdkClientOption<Object>> resolvedOptions = new HashSet<SdkClientOption<Object>>();
        resolvedOptions.add(SdkClientOption.COMPRESSION_CONFIGURATION);
        resolvedOptions.add(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
        RESOLVED_OPTIONS = Collections.unmodifiableSet(resolvedOptions);
    }

    @SdkInternalApi
    static final class DefaultBuilder
    implements Builder {
        private final SdkClientConfiguration.Builder config;
        private final SdkClientConfiguration.Builder resolvedConfig;

        @SdkInternalApi
        DefaultBuilder(SdkClientConfiguration.Builder config) {
            this();
            RESOLVED_OPTIONS.forEach(o -> this.copyValue((ClientOption)((Object)o), config, this.resolvedConfig));
            CLIENT_OVERRIDE_OPTIONS.forEach(o -> this.copyValue((ClientOption)((Object)o), config, this.config));
            SdkAdvancedClientOption.options().forEach(o -> this.copyValue((ClientOption)((Object)o), config, this.config));
        }

        private DefaultBuilder() {
            this(SdkClientConfiguration.builder(), SdkClientConfiguration.builder());
        }

        private DefaultBuilder(SdkClientConfiguration.Builder config, SdkClientConfiguration.Builder resolvedConfig) {
            this.config = config;
            this.resolvedConfig = resolvedConfig;
        }

        @Override
        public Builder headers(Map<String, List<String>> headers) {
            Validate.paramNotNull(headers, (String)"headers");
            this.config.option(SdkClientOption.ADDITIONAL_HTTP_HEADERS, CollectionUtils.deepCopyMap(headers, this::newHeaderMap));
            return this;
        }

        public void setHeaders(Map<String, List<String>> additionalHttpHeaders) {
            this.headers(additionalHttpHeaders);
        }

        @Override
        public Map<String, List<String>> headers() {
            Map option = (Map)Validate.getOrDefault(this.config.option(SdkClientOption.ADDITIONAL_HTTP_HEADERS), Collections::emptyMap);
            return CollectionUtils.unmodifiableMapOfLists((Map)option);
        }

        @Override
        public Builder putHeader(String header, List<String> values) {
            Validate.paramNotNull((Object)header, (String)"header");
            Validate.paramNotNull(values, (String)"values");
            this.config.computeOptionIfAbsent(SdkClientOption.ADDITIONAL_HTTP_HEADERS, this::newHeaderMap).put(header, new ArrayList<String>(values));
            return this;
        }

        @Override
        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.config.option(SdkClientOption.RETRY_POLICY, retryPolicy);
            this.config.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
            this.config.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
            this.config.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
            return this;
        }

        public void setRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy(retryPolicy);
        }

        @Override
        public RetryPolicy retryPolicy() {
            return this.config.option(SdkClientOption.RETRY_POLICY);
        }

        @Override
        public Builder retryStrategy(RetryStrategy retryStrategy) {
            Validate.paramNotNull((Object)retryStrategy, (String)"retryStrategy");
            this.config.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, retryStrategy);
            this.config.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
            this.config.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
            this.config.option(SdkClientOption.RETRY_POLICY, null);
            return this;
        }

        @Override
        public Builder retryStrategy(Consumer<RetryStrategy.Builder<?, ?>> configurator) {
            Validate.paramNotNull(configurator, (String)"configurator");
            this.config.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, configurator);
            this.config.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
            this.config.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
            this.config.option(SdkClientOption.RETRY_POLICY, null);
            return this;
        }

        @Override
        public Builder retryStrategy(RetryMode retryMode) {
            Validate.paramNotNull((Object)((Object)retryMode), (String)"retryMode");
            this.config.option(SdkClientOption.CONFIGURED_RETRY_MODE, retryMode);
            this.config.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
            this.config.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
            this.config.option(SdkClientOption.RETRY_POLICY, null);
            return this;
        }

        public void setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy(retryStrategy);
        }

        @Override
        public RetryStrategy retryStrategy() {
            RetryStrategy retryStrategy = this.config.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY);
            if (retryStrategy != null) {
                return retryStrategy;
            }
            if (this.config.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR) != null) {
                return null;
            }
            if (this.config.option(SdkClientOption.CONFIGURED_RETRY_MODE) != null) {
                return null;
            }
            return this.config.option(SdkClientOption.RETRY_STRATEGY);
        }

        @Override
        public RetryMode retryMode() {
            return this.config.option(SdkClientOption.CONFIGURED_RETRY_MODE);
        }

        @Override
        public Consumer<RetryStrategy.Builder<?, ?>> retryStrategyConfigurator() {
            return this.config.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR);
        }

        @Override
        public Builder executionInterceptors(List<ExecutionInterceptor> executionInterceptors) {
            Validate.paramNotNull(executionInterceptors, (String)"executionInterceptors");
            this.config.option(SdkClientOption.EXECUTION_INTERCEPTORS, new ArrayList<ExecutionInterceptor>(executionInterceptors));
            return this;
        }

        @Override
        public Builder addExecutionInterceptor(ExecutionInterceptor executionInterceptor) {
            this.config.computeOptionIfAbsent(SdkClientOption.EXECUTION_INTERCEPTORS, ArrayList::new).add(executionInterceptor);
            return this;
        }

        public void setExecutionInterceptors(List<ExecutionInterceptor> executionInterceptors) {
            this.executionInterceptors(executionInterceptors);
        }

        @Override
        public List<ExecutionInterceptor> executionInterceptors() {
            List<ExecutionInterceptor> interceptors = this.config.option(SdkClientOption.EXECUTION_INTERCEPTORS);
            return Collections.unmodifiableList(interceptors == null ? Collections.emptyList() : interceptors);
        }

        @Override
        public ScheduledExecutorService scheduledExecutorService() {
            ScheduledExecutorService resolvedExecutor = this.resolvedConfig.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
            if (resolvedExecutor != null) {
                return resolvedExecutor;
            }
            return ScheduledExecutorUtils.unwrapUnmanagedScheduledExecutor((ScheduledExecutorService)this.config.option(SdkClientOption.CONFIGURED_SCHEDULED_EXECUTOR_SERVICE));
        }

        @Override
        public Builder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.resolvedConfig.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE, null);
            this.config.option(SdkClientOption.CONFIGURED_SCHEDULED_EXECUTOR_SERVICE, ScheduledExecutorUtils.unmanagedScheduledExecutor((ScheduledExecutorService)scheduledExecutorService));
            return this;
        }

        @Override
        public <T> Builder putAdvancedOption(SdkAdvancedClientOption<T> option, T value) {
            this.config.option(option, value);
            return this;
        }

        @Override
        public Builder advancedOptions(Map<SdkAdvancedClientOption<?>, ?> advancedOptions) {
            SdkAdvancedClientOption.options().forEach(o -> this.config.option(o, null));
            this.config.putAll(advancedOptions);
            return this;
        }

        public void setAdvancedOptions(Map<SdkAdvancedClientOption<?>, Object> advancedOptions) {
            this.advancedOptions(advancedOptions);
        }

        @Override
        public AttributeMap advancedOptions() {
            AttributeMap.Builder resultBuilder = AttributeMap.builder();
            SdkAdvancedClientOption.options().forEach(o -> this.setValue((ClientOption)((Object)o), resultBuilder));
            return resultBuilder.build();
        }

        @Override
        public Builder apiCallTimeout(Duration apiCallTimeout) {
            this.config.option(SdkClientOption.API_CALL_TIMEOUT, apiCallTimeout);
            return this;
        }

        public void setApiCallTimeout(Duration apiCallTimeout) {
            this.apiCallTimeout(apiCallTimeout);
        }

        @Override
        public Duration apiCallTimeout() {
            return this.config.option(SdkClientOption.API_CALL_TIMEOUT);
        }

        @Override
        public Builder apiCallAttemptTimeout(Duration apiCallAttemptTimeout) {
            this.config.option(SdkClientOption.API_CALL_ATTEMPT_TIMEOUT, apiCallAttemptTimeout);
            return this;
        }

        public void setApiCallAttemptTimeout(Duration apiCallAttemptTimeout) {
            this.apiCallAttemptTimeout(apiCallAttemptTimeout);
        }

        @Override
        public Duration apiCallAttemptTimeout() {
            return this.config.option(SdkClientOption.API_CALL_ATTEMPT_TIMEOUT);
        }

        @Override
        public Builder defaultProfileFileSupplier(Supplier<ProfileFile> defaultProfileFileSupplier) {
            this.config.option(SdkClientOption.PROFILE_FILE_SUPPLIER, defaultProfileFileSupplier);
            return this;
        }

        @Override
        public Supplier<ProfileFile> defaultProfileFileSupplier() {
            return this.config.option(SdkClientOption.PROFILE_FILE_SUPPLIER);
        }

        @Override
        public ProfileFile defaultProfileFile() {
            Supplier<ProfileFile> supplier = this.defaultProfileFileSupplier();
            return supplier == null ? null : supplier.get();
        }

        @Override
        public Builder defaultProfileFile(ProfileFile defaultProfileFile) {
            this.defaultProfileFileSupplier((Supplier<ProfileFile>)ProfileFileSupplier.fixedProfileFile((ProfileFile)defaultProfileFile));
            return this;
        }

        @Override
        public String defaultProfileName() {
            return this.config.option(SdkClientOption.PROFILE_NAME);
        }

        @Override
        public Builder defaultProfileName(String defaultProfileName) {
            this.config.option(SdkClientOption.PROFILE_NAME, defaultProfileName);
            return this;
        }

        @Override
        public Builder metricPublishers(List<MetricPublisher> metricPublishers) {
            Validate.paramNotNull(metricPublishers, (String)"metricPublishers");
            this.config.option(SdkClientOption.METRIC_PUBLISHERS, new ArrayList<MetricPublisher>(metricPublishers));
            return this;
        }

        public void setMetricPublishers(List<MetricPublisher> metricPublishers) {
            this.metricPublishers(metricPublishers);
        }

        @Override
        public Builder addMetricPublisher(MetricPublisher metricPublisher) {
            Validate.paramNotNull((Object)metricPublisher, (String)"metricPublisher");
            this.config.computeOptionIfAbsent(SdkClientOption.METRIC_PUBLISHERS, ArrayList::new).add(metricPublisher);
            return this;
        }

        @Override
        public List<MetricPublisher> metricPublishers() {
            List<MetricPublisher> metricPublishers = this.config.option(SdkClientOption.METRIC_PUBLISHERS);
            return Collections.unmodifiableList(metricPublishers == null ? Collections.emptyList() : metricPublishers);
        }

        @Override
        public Builder executionAttributes(ExecutionAttributes executionAttributes) {
            Validate.paramNotNull((Object)executionAttributes, (String)"executionAttributes");
            this.config.option(SdkClientOption.EXECUTION_ATTRIBUTES, executionAttributes);
            return this;
        }

        @Override
        public <T> Builder putExecutionAttribute(ExecutionAttribute<T> executionAttribute, T value) {
            this.config.computeOptionIfAbsent(SdkClientOption.EXECUTION_ATTRIBUTES, ExecutionAttributes::new).putAttribute(executionAttribute, value);
            return this;
        }

        @Override
        public ExecutionAttributes executionAttributes() {
            ExecutionAttributes attributes = this.config.option(SdkClientOption.EXECUTION_ATTRIBUTES);
            return attributes == null ? new ExecutionAttributes() : attributes;
        }

        @Override
        public Builder compressionConfiguration(CompressionConfiguration compressionConfiguration) {
            this.resolvedConfig.option(SdkClientOption.COMPRESSION_CONFIGURATION, null);
            this.config.option(SdkClientOption.CONFIGURED_COMPRESSION_CONFIGURATION, compressionConfiguration);
            return this;
        }

        public void setRequestCompressionEnabled(CompressionConfiguration compressionConfiguration) {
            this.compressionConfiguration(compressionConfiguration);
        }

        @Override
        public CompressionConfiguration compressionConfiguration() {
            CompressionConfiguration resolvedCompressionConfig = this.resolvedConfig.option(SdkClientOption.COMPRESSION_CONFIGURATION);
            if (resolvedCompressionConfig != null) {
                return resolvedCompressionConfig;
            }
            return this.config.option(SdkClientOption.CONFIGURED_COMPRESSION_CONFIGURATION);
        }

        @Override
        public String appId() {
            return this.config.option(SdkClientOption.USER_AGENT_APP_ID);
        }

        @Override
        public Builder appId(String appId) {
            this.config.option(SdkClientOption.USER_AGENT_APP_ID, appId);
            return this;
        }

        public ClientOverrideConfiguration build() {
            return new ClientOverrideConfiguration(this.config.build(), this.resolvedConfig.build());
        }

        private Map<String, List<String>> newHeaderMap() {
            return new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        }

        private <T> void copyValue(ClientOption<T> option, SdkClientConfiguration.Builder src, SdkClientConfiguration.Builder dst) {
            T value = src.option(option);
            if (value != null) {
                dst.option(option, value);
            }
        }

        private <T> void setValue(ClientOption<T> option, AttributeMap.Builder dst) {
            T value = this.config.option(option);
            if (value != null) {
                dst.put(option, value);
            }
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClientOverrideConfiguration> {
        default public Builder putHeader(String name, String value) {
            this.putHeader(name, Collections.singletonList(value));
            return this;
        }

        public Builder putHeader(String var1, List<String> var2);

        public Builder headers(Map<String, List<String>> var1);

        public Map<String, List<String>> headers();

        @Deprecated
        public Builder retryPolicy(RetryPolicy var1);

        @Deprecated
        default public Builder retryPolicy(Consumer<RetryPolicy.Builder> retryPolicy) {
            return this.retryPolicy(((RetryPolicy.Builder)RetryPolicy.builder().applyMutation(retryPolicy)).build());
        }

        @Deprecated
        default public Builder retryPolicy(RetryMode retryMode) {
            return this.retryPolicy(RetryPolicy.forRetryMode(retryMode));
        }

        public RetryPolicy retryPolicy();

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(RetryMode retryMode) {
            throw new UnsupportedOperationException();
        }

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder<?, ?>> configurator) {
            throw new UnsupportedOperationException();
        }

        public RetryStrategy retryStrategy();

        public RetryMode retryMode();

        public Consumer<RetryStrategy.Builder<?, ?>> retryStrategyConfigurator();

        public Builder executionInterceptors(List<ExecutionInterceptor> var1);

        public Builder addExecutionInterceptor(ExecutionInterceptor var1);

        public List<ExecutionInterceptor> executionInterceptors();

        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public ScheduledExecutorService scheduledExecutorService();

        public <T> Builder putAdvancedOption(SdkAdvancedClientOption<T> var1, T var2);

        public Builder advancedOptions(Map<SdkAdvancedClientOption<?>, ?> var1);

        public AttributeMap advancedOptions();

        public Builder apiCallTimeout(Duration var1);

        public Duration apiCallTimeout();

        public Builder apiCallAttemptTimeout(Duration var1);

        public Duration apiCallAttemptTimeout();

        public Builder defaultProfileFileSupplier(Supplier<ProfileFile> var1);

        public Supplier<ProfileFile> defaultProfileFileSupplier();

        public Builder defaultProfileFile(ProfileFile var1);

        public ProfileFile defaultProfileFile();

        public Builder defaultProfileName(String var1);

        public String defaultProfileName();

        public Builder metricPublishers(List<MetricPublisher> var1);

        public Builder addMetricPublisher(MetricPublisher var1);

        public List<MetricPublisher> metricPublishers();

        public Builder executionAttributes(ExecutionAttributes var1);

        public <T> Builder putExecutionAttribute(ExecutionAttribute<T> var1, T var2);

        public ExecutionAttributes executionAttributes();

        public Builder compressionConfiguration(CompressionConfiguration var1);

        default public Builder compressionConfiguration(Consumer<CompressionConfiguration.Builder> compressionConfiguration) {
            return this.compressionConfiguration((CompressionConfiguration)((CompressionConfiguration.Builder)CompressionConfiguration.builder().applyMutation(compressionConfiguration)).build());
        }

        public CompressionConfiguration compressionConfiguration();

        public Builder appId(String var1);

        public String appId();
    }
}

