/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results;

import com.amazon.athena.client.results.AsyncQueryResults;
import com.amazon.athena.client.results.AsyncQueryResultsFactory;
import com.amazon.athena.client.results.GetQueryResultsStreamQueryResultsFactory;
import com.amazon.athena.client.results.ResultParserFactory;
import com.amazon.athena.client.results.S3StreamingQueryResultsFactory;
import com.amazon.athena.logging.AthenaLogger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.EncryptionOption;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athenastreaming.AthenaStreamingAsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.utils.CompletableFutureUtils;

public class AutoQueryResultsFactory
implements AsyncQueryResultsFactory {
    private static final AthenaLogger logger = AthenaLogger.of(AutoQueryResultsFactory.class);
    private final S3StreamingQueryResultsFactory s3StreamingQueryResultsFactory;
    private final GetQueryResultsStreamQueryResultsFactory getQueryResultsStreamQueryResultsFactory;

    public AutoQueryResultsFactory(AthenaAsyncClient athenaClient, AthenaStreamingAsyncClient athenaStreamingClient, S3AsyncClient s3Client, Executor executor, ResultParserFactory resultParserFactory) {
        this(new S3StreamingQueryResultsFactory(athenaClient, s3Client, executor, resultParserFactory, true), new GetQueryResultsStreamQueryResultsFactory(athenaStreamingClient, executor, resultParserFactory));
    }

    AutoQueryResultsFactory(S3StreamingQueryResultsFactory s3StreamingQueryResultsFactory, GetQueryResultsStreamQueryResultsFactory getQueryResultsStreamQueryResultsFactory) {
        this.s3StreamingQueryResultsFactory = s3StreamingQueryResultsFactory;
        this.getQueryResultsStreamQueryResultsFactory = getQueryResultsStreamQueryResultsFactory;
    }

    @Override
    public CompletionStage<AsyncQueryResults> create(QueryExecution queryMetadata) {
        if (!this.hasOutputLocation(queryMetadata)) {
            logger.info("Falling back on GetQueryResultsStream because query metadata had no output location", new Object[0]);
            return this.getQueryResultsStreamQueryResultsFactory.create(queryMetadata);
        }
        if (this.usesCseKms(queryMetadata)) {
            logger.info("Falling back on GetQueryResultsStream because the CSE KMS encryption option was used", new Object[0]);
            return this.getQueryResultsStreamQueryResultsFactory.create(queryMetadata);
        }
        logger.debug("Streaming query results from S3", new Object[0]);
        CompletionStage<AsyncQueryResults> pendingS3QueryResults = this.s3StreamingQueryResultsFactory.create(queryMetadata);
        CompletableFuture<AsyncQueryResults> pendingQueryResults = new CompletableFuture<AsyncQueryResults>();
        pendingS3QueryResults.whenComplete((results, error) -> {
            CompletionStage<AsyncQueryResults> pendingActualQueryResults;
            if (error != null && this.isAccessDeniedError((Throwable)error)) {
                logger.info("Falling back on GetQueryResultsStream because S3 returned an AccessDenied error", new Object[0]);
                pendingActualQueryResults = this.getQueryResultsStreamQueryResultsFactory.create(queryMetadata);
            } else {
                pendingActualQueryResults = pendingS3QueryResults;
            }
            CompletableFutureUtils.forwardResultTo(pendingActualQueryResults.toCompletableFuture(), pendingQueryResults);
        });
        return pendingQueryResults;
    }

    private boolean hasOutputLocation(QueryExecution queryMetadata) {
        return queryMetadata.resultConfiguration() != null && queryMetadata.resultConfiguration().outputLocation() != null;
    }

    private boolean usesCseKms(QueryExecution queryMetadata) {
        return queryMetadata.resultConfiguration() != null && queryMetadata.resultConfiguration().encryptionConfiguration() != null && queryMetadata.resultConfiguration().encryptionConfiguration().encryptionOption() != null && queryMetadata.resultConfiguration().encryptionConfiguration().encryptionOption().equals((Object)EncryptionOption.CSE_KMS);
    }

    private boolean isAccessDeniedError(Throwable error) {
        for (Throwable t = error; t != null; t = t.getCause()) {
            if (!(t instanceof S3Exception)) continue;
            AwsErrorDetails errorDetails = ((S3Exception)t).awsErrorDetails();
            return errorDetails.errorCode().equalsIgnoreCase("AccessDenied");
        }
        return false;
    }
}

