/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.TrustedIdentityPropagationAuthenticationWorkflow;
import com.amazon.athena.jdbc.authentication.oidc.AuthorizationCodeOpenIdConnectFlow;
import com.amazon.athena.jdbc.cache.Cache;
import com.amazon.athena.jdbc.cache.JwtTokenCacheEntry;
import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.sts.model.Credentials;

public class BrowserOidcTrustedIdentityPropagationCredentialsProvider
implements AwsCredentialsProvider {
    private static final AthenaLogger logger = AthenaLogger.of(BrowserOidcTrustedIdentityPropagationCredentialsProvider.class);
    private static final Duration EXPIRATION_THRESHOLD_SECS = Duration.ofSeconds(180L);
    private final Boolean enableTokenCache;
    private final String cacheKeyForTokenCache;
    private final AuthorizationCodeOpenIdConnectFlow authorizationCodeFlow;
    private final TrustedIdentityPropagationAuthenticationWorkflow trustedIdentityPropagationAuthenticationWorkflow;
    private final Cache<JwtTokenCacheEntry> jwtTokenCache;
    private final Clock clock;
    private Credentials credentials;
    private JwtTokenCacheEntry tokenEntry;

    public BrowserOidcTrustedIdentityPropagationCredentialsProvider(Boolean enableTokenCache, String cacheKeyForTokenCache, AuthorizationCodeOpenIdConnectFlow authorizationCodeFlow, Cache<JwtTokenCacheEntry> jwtTokenCache, TrustedIdentityPropagationAuthenticationWorkflow trustedIdentityPropagationAuthenticationWorkflow) {
        this(enableTokenCache, cacheKeyForTokenCache, authorizationCodeFlow, Clock.systemDefaultZone(), jwtTokenCache, trustedIdentityPropagationAuthenticationWorkflow);
    }

    protected BrowserOidcTrustedIdentityPropagationCredentialsProvider(Boolean enableTokenCache, String cacheKeyForTokenCache, AuthorizationCodeOpenIdConnectFlow authorizationCodeFlow, Clock clock, Cache<JwtTokenCacheEntry> jwtTokenCache, TrustedIdentityPropagationAuthenticationWorkflow trustedIdentityPropagationAuthenticationWorkflow) {
        this.enableTokenCache = enableTokenCache;
        this.cacheKeyForTokenCache = cacheKeyForTokenCache;
        this.authorizationCodeFlow = authorizationCodeFlow;
        this.trustedIdentityPropagationAuthenticationWorkflow = trustedIdentityPropagationAuthenticationWorkflow;
        this.jwtTokenCache = jwtTokenCache;
        this.clock = clock;
    }

    @Override
    public AwsCredentials resolveCredentials() {
        boolean needsUpdate;
        Instant expirationTime = this.clock.instant().plusSeconds(EXPIRATION_THRESHOLD_SECS.getSeconds());
        boolean bl = needsUpdate = this.credentials == null || this.credentials.expiration().compareTo(expirationTime) < 0;
        if (needsUpdate) {
            String webIdentityToken = this.getJwtTokenFromBrowserFlow();
            this.credentials = this.trustedIdentityPropagationAuthenticationWorkflow.obtainCredentials(webIdentityToken);
        }
        return AwsSessionCredentials.create(this.credentials.accessKeyId(), this.credentials.secretAccessKey(), this.credentials.sessionToken());
    }

    private String getJwtTokenFromBrowserFlow() {
        if (!this.enableTokenCache.booleanValue()) {
            logger.info("Trying to fetch web identity token from the Identity Provider without caching.", new Object[0]);
            this.tokenEntry = this.getJwtToken(this.tokenEntry);
        } else {
            logger.info("Trying to fetch web identity token from the Identity Provider with caching.", new Object[0]);
            JwtTokenCacheEntry cachedEntry = this.jwtTokenCache.get(this.cacheKeyForTokenCache).orElse(null);
            this.tokenEntry = this.getJwtToken(cachedEntry);
            this.jwtTokenCache.store(this.cacheKeyForTokenCache, this.tokenEntry);
        }
        return this.tokenEntry.getIdToken();
    }

    private JwtTokenCacheEntry getJwtToken(JwtTokenCacheEntry cachedEntry) {
        JwtTokenCacheEntry newCacheEntry;
        if (cachedEntry == null) {
            logger.debug("No web identity token found, trying to fetch a fresh web identity token.", new Object[0]);
            newCacheEntry = this.authorizationCodeFlow.fetchToken();
        } else if (!cachedEntry.isExpired(EXPIRATION_THRESHOLD_SECS)) {
            logger.debug("web identity token found.", new Object[0]);
            newCacheEntry = cachedEntry;
        } else if (cachedEntry.getRefreshToken() == null || cachedEntry.getRefreshToken().isEmpty()) {
            logger.info("refresh token not found. Scope parameter is missing the scope for refresh token or the Identity Provider settings do not grant refresh token grant.", new Object[0]);
            newCacheEntry = this.authorizationCodeFlow.fetchToken();
        } else {
            try {
                logger.debug("The web identity token is either expired or about to expire, refreshing it.", new Object[0]);
                newCacheEntry = this.authorizationCodeFlow.refreshToken(cachedEntry.getRefreshToken());
            }
            catch (AuthenticationException ex) {
                logger.warn("Failed to refresh the web identity token. Trying to fetch the token with browser flow.", ex);
                newCacheEntry = this.authorizationCodeFlow.fetchToken();
            }
        }
        return newCacheEntry;
    }
}

