/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.datazone;

import com.amazon.athena.logging.AthenaLogger;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentCredentialsRequest;
import software.amazon.awssdk.services.datazone.model.GetEnvironmentCredentialsResponse;

public class DataZoneIamCredentialsProvider
implements AwsCredentialsProvider {
    private static final AthenaLogger logger = AthenaLogger.of(DataZoneIamCredentialsProvider.class);
    private final String domainId;
    private final String environmentId;
    private final DataZoneClient dataZoneClient;

    public DataZoneIamCredentialsProvider(String domainId, String environmentId, DataZoneClient dataZoneClient) {
        this.domainId = domainId;
        this.environmentId = environmentId;
        this.dataZoneClient = dataZoneClient;
    }

    @Override
    public AwsCredentials resolveCredentials() {
        GetEnvironmentCredentialsRequest getEnvironmentCredentialsRequest = (GetEnvironmentCredentialsRequest)GetEnvironmentCredentialsRequest.builder().domainIdentifier(this.domainId).environmentIdentifier(this.environmentId).build();
        logger.trace(String.format("Calling GetEnvironmentCredentials with request: %s", getEnvironmentCredentialsRequest.toString()), new Object[0]);
        GetEnvironmentCredentialsResponse getEnvironmentCredentialsResponse = this.dataZoneClient.getEnvironmentCredentials(getEnvironmentCredentialsRequest);
        logger.info("Retrieved DataZone Environment Credentials", new Object[0]);
        return AwsSessionCredentials.create(getEnvironmentCredentialsResponse.accessKeyId(), getEnvironmentCredentialsResponse.secretAccessKey(), getEnvironmentCredentialsResponse.sessionToken());
    }
}

