/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication.oidc;

import com.amazon.athena.jdbc.authentication.http.BrowserAuthenticationServer;
import com.amazon.athena.jdbc.authentication.http.HttpClientFactory;
import com.amazon.athena.jdbc.authentication.oidc.JwtTokenValidator;
import com.amazon.athena.jdbc.authentication.oidc.OpenIdConnectTemplate;
import com.amazon.athena.jdbc.authentication.oidc.OpenIdConnectWellKnownConfigurationService;
import com.amazon.athena.jdbc.authentication.utils.OpenIdConnectUtils;
import com.amazon.athena.jdbc.cache.JwtTokenCacheEntry;
import com.amazon.athena.jdbc.support.AuthenticationException;
import com.amazon.athena.logging.AthenaLogger;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public class AuthorizationCodeOpenIdConnectFlow
extends OpenIdConnectTemplate {
    private static final AthenaLogger logger = AthenaLogger.of(AuthorizationCodeOpenIdConnectFlow.class);
    private static final String AUTHORIZATION_CODE_GRANT_TYPE = "authorization_code";
    private static final String CODE_CHALLENGE_METHOD = "S256";
    private static final String RESPONSE_TYPE_METHOD = "code";
    private static final String REFRESH_TOKEN_GRANT_TYPE = "refresh_token";
    private static final String HTTP_REQUEST_ACCEPT_HEADER_KEY = "accept";
    private static final String HTTP_REQUEST_ACCEPT_HEADER_VALUE = "application/json";
    private static final String HTTP_REQUEST_CONTENT_TYPE_HEADER_KEY = "Content-Type";
    private static final String HTTP_REQUEST_CONTENT_TYPE_HEADER_VALUE = "application/x-www-form-urlencoded";
    private final String clientId;
    private final String clientSecret;
    private String codeChallenge;
    private String codeVerifier;
    private String state;
    private String nonce;

    public AuthorizationCodeOpenIdConnectFlow(String clientId, String clientSecret, String scope, int localServerPort, int localServerTimeout, Desktop desktop, BrowserAuthenticationServer server, OpenIdConnectWellKnownConfigurationService openIdConnectWellKnownConfigurationService, JwtTokenValidator jwtTokenValidator, HttpClientFactory httpClientFactory) {
        super(scope, localServerPort, localServerTimeout, desktop, server, httpClientFactory, openIdConnectWellKnownConfigurationService, jwtTokenValidator);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    /*
     * Exception decompiling
     */
    @Override
    public JwtTokenCacheEntry refreshToken(String refreshToken) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected String buildAuthorizationEndpointUrl() {
        this.codeVerifier = OpenIdConnectUtils.generateRandomString();
        this.state = OpenIdConnectUtils.generateRandomString();
        this.nonce = OpenIdConnectUtils.generateNonce();
        this.codeChallenge = OpenIdConnectUtils.generateCodeChallenge(this.codeVerifier);
        try {
            URI authorizationUri = new URI(this.openIdConnectWellKnownConfigurationService.getAuthorizationCodeEndpoint());
            return new URIBuilder(authorizationUri).addParameter("client_id", this.clientId).addParameter("response_type", RESPONSE_TYPE_METHOD).addParameter("scope", this.scope).addParameter("redirect_uri", this.redirectUri).addParameter("code_challenge", this.codeChallenge).addParameter("code_challenge_method", CODE_CHALLENGE_METHOD).addParameter("nonce", this.nonce).addParameter("state", this.state).build().toString();
        }
        catch (URISyntaxException e) {
            throw new AuthenticationException("Failed to build authorization URL", e);
        }
    }

    @Override
    protected JwtTokenCacheEntry processAuthResponse(List<NameValuePair> responseFromIdentityProvider) {
        Map<String, String> responseParams = responseFromIdentityProvider.stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
        if (responseParams.containsKey("error")) {
            String error = responseParams.get("error");
            String errorDescription = responseParams.get("error_description");
            throw new AuthenticationException(String.format("Authentication failed due to: %s - %s", error, errorDescription));
        }
        if (responseParams.get(RESPONSE_TYPE_METHOD) == null) {
            throw new AuthenticationException("No authorization code received.");
        }
        logger.info("Successfully received authorization code response from IDP.", new Object[0]);
        return this.exchangeCodeForToken(responseParams.get(RESPONSE_TYPE_METHOD));
    }

    /*
     * Exception decompiling
     */
    private JwtTokenCacheEntry exchangeCodeForToken(String code) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

