/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

class LocateFunction
extends JdbcFunction {
    LocateFunction() {
        super("LOCATE", "STRPOS", JdbcFunction.FunctionCategory.STRING, 2, 3);
    }

    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        if (rawArgs.size() == 3) {
            throw new FunctionExpressionException("The \"start\" argument to the LOCATE function is not supported");
        }
        List<List<Token>> args = super.processArguments(rawArgs);
        LinkedList<Token> newFirstArg = new LinkedList<Token>((Collection)args.get(1));
        LinkedList<Token> newSecondArg = new LinkedList<Token>(this.trimWhitespacePrefix(newFirstArg));
        newSecondArg.addAll((Collection<Token>)args.get(0));
        return Arrays.asList(newFirstArg, newSecondArg);
    }
}

