/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class RightFunction
extends JdbcFunction {
    RightFunction() {
        super("RIGHT", "SUBSTRING", JdbcFunction.FunctionCategory.STRING, 2, 2);
    }

    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> args = super.processArguments(rawArgs);
        return Arrays.asList(args.get(0), this.createNegatedOffsetArg(rawArgs.get(1)));
    }

    private List<Token> createNegatedOffsetArg(List<Token> rawOffset) {
        LinkedList<Token> offset = new LinkedList<Token>(rawOffset);
        List<Token> whitespacePrefix = this.trimWhitespacePrefix(offset);
        List<Token> whitespaceSuffix = this.trimWhitespaceSuffix(offset);
        LinkedList<Token> negatedOffset = new LinkedList<Token>(whitespacePrefix);
        negatedOffset.add(Token.sql("-("));
        negatedOffset.addAll(offset);
        negatedOffset.add(Token.sql(")"));
        negatedOffset.addAll(whitespaceSuffix);
        return this.ensureHasWhitespacePrefix(negatedOffset);
    }
}

