/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.EscapeProcessor;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import com.amazon.athena.jdbc.support.sql.TokenType;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class SqlTokenizer {
    private final String sql;
    private final LinkedList<Token> tokens;
    private int index;
    private int mark;

    SqlTokenizer(String sql) {
        this.sql = sql;
        this.index = 0;
        this.mark = 0;
        this.tokens = new LinkedList();
    }

    static List<Token> tokenize(String sql) throws ParseException {
        return new SqlTokenizer(sql).tokenize();
    }

    List<Token> tokenize() throws ParseException {
        this.tokens.clear();
        this.index = 0;
        this.mark = 0;
        this.consumeSql(null, false);
        return Collections.unmodifiableList(this.tokens);
    }

    private void advance() {
        ++this.index;
    }

    private char peek() {
        return this.peek(0);
    }

    private char peek(int n) {
        return this.sql.charAt(this.index + n);
    }

    private boolean hasNext() {
        return this.index < this.sql.length();
    }

    private ParseException error(String message, Object ... args) {
        return this.error(this.index, message, args);
    }

    private ParseException error(int location, String message, Object ... args) {
        return new ParseException(String.format(message, args), location);
    }

    private void pushToken(TokenType type) {
        this.pushToken(type, this.index);
    }

    private void pushToken(TokenType type, int endIndex) {
        if (this.mark < endIndex) {
            this.tokens.add(new Token(type, this.mark, endIndex, this.sql));
        }
        this.mark = endIndex;
    }

    private void consumeSql(char[] terminals, boolean balanceParenthesis) throws ParseException {
        int parenthesisLevel = 0;
        while (this.hasNext()) {
            char c = this.peek();
            if (terminals != null && parenthesisLevel == 0) {
                for (char t : terminals) {
                    if (c != t) continue;
                    this.pushToken(TokenType.SQL);
                    return;
                }
            }
            if (this.isWhitespaceChar(c)) {
                this.pushToken(TokenType.SQL);
                this.maybeConsumeWhitespace();
                continue;
            }
            if (this.isIdentifierStartChar(c)) {
                this.pushToken(TokenType.SQL);
                this.consumeKeyword();
                continue;
            }
            if (c == '\'') {
                this.pushToken(TokenType.SQL);
                this.consumeStringLiteral();
                continue;
            }
            if (c == '\"') {
                this.pushToken(TokenType.SQL);
                this.consumeQuotedIdentifier();
                continue;
            }
            if (this.maybeConsumeComment()) {
                this.maybeConsumeWhitespace();
                continue;
            }
            if (c == '{') {
                this.pushToken(TokenType.SQL, this.index);
                this.consumeChar(TokenType.ESCAPE_SEQUENCE_START, '{');
                this.maybeConsumeWhitespace();
                this.consumeEscapeSequence();
                this.consumeChar(TokenType.ESCAPE_SEQUENCE_END, '}');
                continue;
            }
            if (c == '(' && balanceParenthesis) {
                ++parenthesisLevel;
                this.advance();
                continue;
            }
            if (c == ')' && balanceParenthesis) {
                --parenthesisLevel;
                this.advance();
                continue;
            }
            if (c == '?') {
                this.consumeChar(TokenType.PARAMETER_PLACEHOLDER, '?');
                continue;
            }
            this.advance();
        }
        this.pushToken(TokenType.SQL);
    }

    private void consumeKeyword() throws ParseException {
        this.advance();
        while (this.hasNext()) {
            char c = this.peek();
            if (!this.isIdentifierChar(c)) {
                this.pushToken(TokenType.SQL);
                break;
            }
            this.advance();
        }
    }

    private boolean maybeConsumeComment() throws ParseException {
        if (this.hasNext()) {
            char c = this.peek();
            if (c == '-') {
                if (this.hasNext() && this.peek(1) == '-') {
                    this.pushToken(TokenType.SQL, this.index);
                    this.consumeLineComment();
                    return true;
                }
            } else if (c == '/' && this.hasNext() && this.peek(1) == '*') {
                this.pushToken(TokenType.SQL, this.index);
                this.consumeMultiLineComment();
                return true;
            }
        }
        return false;
    }

    private void consumeChar(TokenType tokenType, char chr) throws ParseException {
        if (this.hasNext()) {
            char c = this.peek();
            if (c != chr) {
                throw this.error("Expected %s, found \"%s\"", tokenType.tokenName(), Character.valueOf(c));
            }
        } else {
            throw this.error("Expected %s, found end of statement", tokenType.tokenName());
        }
        this.advance();
        this.pushToken(tokenType);
    }

    private void consumeDelimited(TokenType tokenType, char delimiterChar, boolean doubleDelimiterIsEscape, boolean endOfStatementIsDelimiter) throws ParseException {
        this.advance();
        while (this.hasNext()) {
            char c = this.peek();
            this.advance();
            if (c != delimiterChar) continue;
            if (!doubleDelimiterIsEscape || !this.hasNext() || this.peek() != delimiterChar) {
                this.pushToken(tokenType);
                return;
            }
            this.advance();
        }
        if (this.hasNext() || !endOfStatementIsDelimiter) {
            String delimiterCharName = delimiterChar == '\n' ? "newline" : String.format("\"%s\"", Character.valueOf(delimiterChar));
            throw this.error(String.format("Expected %s at end of %s, found end of statement", delimiterCharName, tokenType.tokenName()), new Object[0]);
        }
    }

    private void consumeStringLiteral() throws ParseException {
        this.consumeDelimited(TokenType.STRING_LITERAL, '\'', true, false);
    }

    private void consumeQuotedIdentifier() throws ParseException {
        this.consumeDelimited(TokenType.QUOTED_IDENTIFIER, '\"', true, false);
    }

    private void consumeLineComment() throws ParseException {
        this.consumeDelimited(TokenType.LINE_COMMENT, '\n', false, true);
    }

    private void consumeMultiLineComment() throws ParseException {
        this.advance();
        while (this.hasNext()) {
            char c = this.peek();
            this.advance();
            if (c != '*' || !this.hasNext() || this.peek() != '/') continue;
            this.advance();
            this.pushToken(TokenType.MULTI_LINE_COMMENT);
            return;
        }
        throw this.error("Expected end of multi line comment, found end of statement", new Object[0]);
    }

    private void consumeEscapeSequence() throws ParseException {
        this.consumeEscapeSequenceType();
        Token escapeSequenceTypeToken = this.tokens.peekLast();
        this.maybeConsumeWhitespace();
        switch (escapeSequenceTypeToken.value().toLowerCase()) {
            case "fn": {
                this.consumeFunctionEscape();
                break;
            }
            case "d": {
                this.consumeStringValuedEscape(TokenType.DATE_LITERAL);
                break;
            }
            case "t": {
                this.consumeStringValuedEscape(TokenType.TIME_LITERAL);
                break;
            }
            case "ts": {
                this.consumeStringValuedEscape(TokenType.TIMESTAMP_LITERAL);
                break;
            }
            case "escape": {
                this.consumeStringValuedEscape(TokenType.ESCAPE_LITERAL);
                break;
            }
            case "limit": {
                this.consumeLimit();
                break;
            }
            case "oj": {
                this.consumeOuterJoinEscape();
                break;
            }
            default: {
                throw this.error(escapeSequenceTypeToken.startIndex(), "Unsupported escape sequence type \"%s\"", escapeSequenceTypeToken.value());
            }
        }
        this.maybeConsumeWhitespace();
        while (this.maybeConsumeComment()) {
            this.maybeConsumeWhitespace();
        }
    }

    private void consumeFunctionEscape() throws ParseException {
        this.consumeFunctionCall();
        this.maybeConsumeWhitespace();
        while (this.maybeConsumeComment()) {
            this.maybeConsumeWhitespace();
        }
    }

    private void consumeStringValuedEscape(TokenType type) throws ParseException {
        if (this.peek() != '\'') {
            throw this.error("Expected %s, found \"%s\"", type.tokenName(), Character.valueOf(this.peek()));
        }
        this.consumeDelimited(type, '\'', true, false);
    }

    private void consumeOuterJoinEscape() throws ParseException {
        if (this.peek() == '}') {
            throw this.error("Expected outer join, found \"%s\"", Character.valueOf(this.peek()));
        }
        this.consumeSql(new char[]{'}'}, false);
    }

    private void consumeEscapeSequenceType() throws ParseException {
        if (this.hasNext() && !this.isIdentifierChar(this.peek())) {
            throw this.error("Expected escape sequence type, found \"%s\"", Character.valueOf(this.peek()));
        }
        while (this.hasNext()) {
            char c = this.peek();
            if (this.isWhitespaceChar(c)) {
                this.pushToken(TokenType.ESCAPE_SEQUENCE_TYPE);
                return;
            }
            if (!this.isIdentifierChar(c)) {
                throw this.error(String.format("Expected end of escape sequence type, found \"%s\"", Character.valueOf(c)), new Object[0]);
            }
            this.advance();
        }
        throw this.error("Expected space after escape sequence type, found end of statement", new Object[0]);
    }

    private void maybeConsumeWhitespace() throws ParseException {
        while (this.hasNext()) {
            char c = this.peek();
            if (this.isWhitespaceChar(c)) {
                this.advance();
                continue;
            }
            this.pushToken(TokenType.WHITESPACE);
            return;
        }
    }

    private void consumeLimit() throws ParseException {
        if (!this.isNumberChar(this.peek())) {
            throw this.error("Expected limit to be a positive integer, found \"%s\"", Character.valueOf(this.peek()));
        }
        while (this.hasNext()) {
            char c = this.peek();
            if (this.isNumberChar(c)) {
                this.advance();
                continue;
            }
            if (this.isWhitespaceChar(c) || c == '}') {
                this.pushToken(TokenType.NUMBER_LITERAL);
                return;
            }
            throw this.error("Expected limit to be a positive integer, found \"%s\"", Character.valueOf(c));
        }
    }

    private void consumeFunctionCall() throws ParseException {
        this.consumeFunctionName();
        String functionName = this.tokens.peekLast().value();
        JdbcFunction function = EscapeProcessor.FUNCTIONS.get(functionName.toUpperCase());
        this.maybeConsumeWhitespace();
        if (!this.hasNext()) {
            if (function != null && function.isOperator()) {
                return;
            }
            throw this.error("Expected \"(\" after function name, found end of statement", new Object[0]);
        }
        if (function == null) {
            throw this.error(this.index - functionName.length(), String.format("The function \"%s\" is not supported", functionName), new Object[0]);
        }
        if (this.hasNext() && this.peek() == '(') {
            this.consumeChar(TokenType.FUNCTION_ARGUMENTS_START, '(');
            this.consumeFunctionArguments();
            this.consumeChar(TokenType.FUNCTION_ARGUMENTS_END, ')');
        } else if (!function.isOperator()) {
            throw this.error("Expected \"(\" after function name, found \"%s\"", Character.valueOf(this.peek()));
        }
    }

    private void consumeFunctionName() throws ParseException {
        char c;
        if (this.hasNext() && !this.isIdentifierChar(this.peek())) {
            throw this.error("Expected function name, found \"%s\"", Character.valueOf(this.peek()));
        }
        while (this.hasNext() && this.isIdentifierChar(c = this.peek())) {
            this.advance();
        }
        this.pushToken(TokenType.FUNCTION_NAME);
    }

    private void consumeFunctionArguments() throws ParseException {
        while (this.hasNext()) {
            this.maybeConsumeWhitespace();
            this.consumeFunctionArgument();
            if (this.hasNext()) {
                char c = this.peek();
                if (c == ',') {
                    this.advance();
                    this.pushToken(TokenType.FUNCTION_ARGUMENT_SEPARATOR);
                    continue;
                }
                if (c != ')') continue;
                break;
            }
            throw this.error("Expected \")\" after function arguments, found end of statement", new Object[0]);
        }
    }

    private void consumeFunctionArgument() throws ParseException {
        this.consumeSql(new char[]{',', ')'}, true);
    }

    private boolean isIdentifierStartChar(char c) {
        return c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private boolean isIdentifierChar(char c) {
        return this.isIdentifierStartChar(c) || this.isNumberChar(c);
    }

    private boolean isNumberChar(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isWhitespaceChar(char c) {
        return c == ' ' || c == '\n' || c == '\t';
    }
}

