/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import com.amazon.athena.jdbc.support.sql.TokenType;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class SubstringFunction
extends JdbcFunction {
    SubstringFunction() {
        super("SUBSTRING", "SUBSTRING", JdbcFunction.FunctionCategory.STRING, 3, 4);
    }

    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> args = super.processArguments(rawArgs);
        if (this.isOctets(args)) {
            LinkedList<Token> newFirstArg = new LinkedList<Token>();
            for (Token token : args.get(0)) {
                if (token.type() == TokenType.SQL) {
                    newFirstArg.add(Token.sql("CAST("));
                    newFirstArg.add(token);
                    newFirstArg.add(Token.sql(" AS VARBINARY)"));
                    continue;
                }
                newFirstArg.add(token);
            }
            return Arrays.asList(newFirstArg, args.get(1), args.get(2));
        }
        return args.subList(0, 3);
    }

    @Override
    List<Token> processFunctionCall(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> args = super.processArguments(rawArgs);
        if (this.isOctets(args)) {
            List<Token> functionCallTokens = super.processFunctionCall(rawArgs);
            functionCallTokens.set(0, Token.sql("SUBSTR"));
            return functionCallTokens;
        }
        return super.processFunctionCall(rawArgs);
    }

    private boolean isOctets(List<List<Token>> args) {
        if (args.size() == 4) {
            return this.findFirstExpression(args.get(3)).map(Token::value).map(s -> s.equalsIgnoreCase("octets")).orElse(false);
        }
        return false;
    }
}

