/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.TokenType;
import lombok.Generated;

class Token {
    private final TokenType type;
    private final int startIndex;
    private final int endIndex;
    private final String source;

    static Token sql(String sql) {
        return new Token(TokenType.SQL, 0, sql.length(), sql);
    }

    static Token space() {
        return new Token(TokenType.WHITESPACE, 0, 1, " ");
    }

    String value() {
        return this.source.substring(this.startIndex, this.endIndex);
    }

    boolean isComment() {
        return this.type == TokenType.LINE_COMMENT || this.type == TokenType.MULTI_LINE_COMMENT;
    }

    boolean isWhitespace() {
        return this.type == TokenType.WHITESPACE;
    }

    boolean isSql() {
        return this.type == TokenType.SQL;
    }

    @Generated
    public Token(TokenType type, int startIndex, int endIndex, String source) {
        this.type = type;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.source = source;
    }

    @Generated
    public TokenType type() {
        return this.type;
    }

    @Generated
    public int startIndex() {
        return this.startIndex;
    }

    @Generated
    public int endIndex() {
        return this.endIndex;
    }

    @Generated
    public String source() {
        return this.source;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.startIndex() != other.startIndex()) {
            return false;
        }
        if (this.endIndex() != other.endIndex()) {
            return false;
        }
        TokenType this$type = this.type();
        TokenType other$type = other.type();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$source = this.source();
        String other$source = other.source();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.startIndex();
        result = result * 59 + this.endIndex();
        TokenType $type = this.type();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $source = this.source();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Token(type=" + (Object)((Object)this.type()) + ", startIndex=" + this.startIndex() + ", endIndex=" + this.endIndex() + ", source=" + this.source() + ")";
    }
}

