/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.useragent.BusinessMetricFeatureId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class StaticCredentialsProvider
implements AwsCredentialsProvider {
    private static final String PROVIDER_NAME = BusinessMetricFeatureId.CREDENTIALS_CODE.value();
    private final AwsCredentials credentials;

    private StaticCredentialsProvider(AwsCredentials credentials) {
        Validate.notNull(credentials, "Credentials must not be null.", new Object[0]);
        this.credentials = this.withProviderName(credentials);
    }

    private AwsCredentials withProviderName(AwsCredentials credentials) {
        if (credentials instanceof AwsBasicCredentials) {
            AwsBasicCredentials basicCreds = (AwsBasicCredentials)credentials;
            if (basicCreds.providerName().isPresent()) {
                return basicCreds;
            }
            return basicCreds.copy(c -> c.providerName(PROVIDER_NAME));
        }
        if (credentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials sessionCreds = (AwsSessionCredentials)credentials;
            if (sessionCreds.providerName().isPresent()) {
                return sessionCreds;
            }
            return sessionCreds.copy(c -> c.providerName(PROVIDER_NAME));
        }
        return credentials;
    }

    public static StaticCredentialsProvider create(AwsCredentials credentials) {
        return new StaticCredentialsProvider(credentials);
    }

    @Override
    public AwsCredentials resolveCredentials() {
        return this.credentials;
    }

    public String toString() {
        return ToString.builder(PROVIDER_NAME).add("credentials", this.credentials).build();
    }
}

