/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.ClassLoaderHelper;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class ConstructorCache {
    private static final Logger log = Logger.loggerFor(ConstructorCache.class);
    private final Map<String, Optional<WeakReference<Class<?>>>> classesByClassName = new ConcurrentHashMap();

    private Optional<Class<?>> getClass(String className) {
        Optional classRef = this.classesByClassName.computeIfAbsent(className, k -> {
            try {
                Class<?> clazz = ClassLoaderHelper.loadClass(k, false, new Class[0]);
                return Optional.of(new WeakReference(clazz));
            }
            catch (ClassNotFoundException e) {
                return Optional.empty();
            }
        });
        if (classRef.isPresent()) {
            Class clazz = (Class)((WeakReference)classRef.get()).get();
            if (clazz != null) {
                return Optional.of(clazz);
            }
            this.classesByClassName.remove(className);
            return this.getClass(className);
        }
        return Optional.empty();
    }

    public Optional<Constructor<?>> getConstructor(String className) {
        return this.getClass(className).flatMap(clazz -> {
            try {
                return Optional.of(clazz.getConstructor(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                log.debug(() -> "Classloader contains " + className + ", but without a zero-arg constructor.", e);
                return Optional.empty();
            }
        });
    }
}

