/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.metrics;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.io.SdkFilterInputStream;
import software.amazon.awssdk.http.Abortable;
import software.amazon.awssdk.http.AbortableInputStream;

@SdkInternalApi
public final class BytesReadTrackingInputStream
extends SdkFilterInputStream
implements Abortable {
    private final Abortable abortableIs;
    private final AtomicLong bytesRead;

    public BytesReadTrackingInputStream(AbortableInputStream in, AtomicLong bytesRead) {
        super(in);
        this.abortableIs = in;
        this.bytesRead = bytesRead;
    }

    public long bytesRead() {
        return this.bytesRead.get();
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        this.updateBytesRead(read);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.updateBytesRead(read);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this.updateBytesRead(skipped);
        return skipped;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        this.updateBytesRead(read);
        return read;
    }

    private void updateBytesRead(long read) {
        if (read > 0L) {
            this.bytesRead.addAndGet(read);
        }
    }

    @Override
    public void abort() {
        this.abortableIs.abort();
    }
}

