/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.sync;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;

@SdkInternalApi
@NotThreadSafe
public final class BufferingContentStreamProvider
implements ContentStreamProvider {
    private final ContentStreamProvider delegate;
    private final Long expectedLength;
    private BufferStream bufferedStream;
    private byte[] bufferedStreamData;
    private int count;

    public BufferingContentStreamProvider(ContentStreamProvider delegate, Long expectedLength) {
        this.delegate = delegate;
        this.expectedLength = expectedLength;
    }

    @Override
    public InputStream newStream() {
        if (this.bufferedStreamData != null) {
            return new ByteArrayStream(this.bufferedStreamData, 0, this.count);
        }
        if (this.bufferedStream == null) {
            InputStream delegateStream = this.delegate.newStream();
            this.bufferedStream = new BufferStream(delegateStream);
            IoUtils.markStreamWithMaxReadLimit(this.bufferedStream, Integer.MAX_VALUE);
        }
        FunctionalUtils.invokeSafely(this.bufferedStream::reset);
        return this.bufferedStream;
    }

    @Override
    public String name() {
        return ContentStreamProvider.ProviderType.STREAM.getName();
    }

    private void saveBuffer() {
        if (this.bufferedStreamData == null) {
            this.bufferedStreamData = this.bufferedStream.getBuf();
            this.count = this.bufferedStream.getCount();
        }
    }

    private boolean expectedLengthReached() {
        return (long)this.bufferedStream.getCount() >= this.expectedLength;
    }

    private boolean hasExpectedLength() {
        return this.expectedLength != null;
    }

    class BufferStream
    extends BufferedInputStream {
        BufferStream(InputStream in) {
            super(in);
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void close() throws IOException {
            if (!BufferingContentStreamProvider.this.hasExpectedLength() || BufferingContentStreamProvider.this.expectedLengthReached()) {
                BufferingContentStreamProvider.this.saveBuffer();
                super.close();
            }
        }
    }

    class ByteArrayStream
    extends ByteArrayInputStream {
        ByteArrayStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        @Override
        public void close() throws IOException {
            super.close();
            BufferingContentStreamProvider.this.bufferedStream.close();
        }
    }
}

