/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.core;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.TraitType;
import software.amazon.awssdk.protocols.core.StringToInstant;

@SdkProtectedApi
public final class NumberToInstant {
    private final Map<MarshallLocation, TimestampFormatTrait.Format> defaultFormats;
    private final StringToInstant stringToInstant;

    private NumberToInstant(Map<MarshallLocation, TimestampFormatTrait.Format> defaultFormats) {
        this.stringToInstant = StringToInstant.create(defaultFormats);
        this.defaultFormats = defaultFormats;
    }

    public Instant convert(Number value, SdkField<Instant> field) {
        if (value == null) {
            return null;
        }
        if (field.location() != MarshallLocation.PAYLOAD) {
            return this.stringToInstant.convert(value.toString(), (SdkField)field);
        }
        TimestampFormatTrait.Format format = this.resolveTimestampFormat(field);
        switch (format) {
            case UNIX_TIMESTAMP: {
                return Instant.ofEpochMilli(Math.round(value.doubleValue() * 1000.0));
            }
            case UNIX_TIMESTAMP_MILLIS: {
                return Instant.ofEpochMilli(value.longValue());
            }
        }
        return this.stringToInstant.convert(value.toString(), (SdkField)field);
    }

    private TimestampFormatTrait.Format resolveTimestampFormat(SdkField<Instant> field) {
        TimestampFormatTrait trait = field.getTrait(TimestampFormatTrait.class, TraitType.TIMESTAMP_FORMAT_TRAIT);
        if (trait == null) {
            TimestampFormatTrait.Format format = this.defaultFormats.get((Object)field.location());
            if (format == null) {
                throw SdkClientException.create(String.format("Timestamps are not supported for this location (%s)", new Object[]{field.location()}));
            }
            return format;
        }
        return trait.format();
    }

    public static NumberToInstant create(Map<MarshallLocation, TimestampFormatTrait.Format> defaultFormats) {
        return new NumberToInstant(defaultFormats);
    }
}

