/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.internal.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public class ConnectionUtils {
    public static ConnectionUtils create() {
        return new ConnectionUtils();
    }

    public HttpURLConnection connectToEndpoint(URI endpoint, Map<String, String> headers) throws IOException {
        return this.connectToEndpoint(endpoint, headers, "GET");
    }

    public HttpURLConnection connectToEndpoint(URI endpoint, Map<String, String> headers, String method) throws IOException {
        return this.connectToEndpoint(endpoint, headers, method, null);
    }

    private HttpURLConnection connectToEndpoint(URI endpoint, Map<String, String> headers, String method, Duration serviceTimeout) throws IOException {
        int timeout = serviceTimeout != null ? NumericUtils.saturatedCast(serviceTimeout.toMillis()) : 1000;
        HttpURLConnection connection = (HttpURLConnection)endpoint.toURL().openConnection(Proxy.NO_PROXY);
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        headers.forEach(connection::addRequestProperty);
        connection.setInstanceFollowRedirects(false);
        connection.connect();
        return connection;
    }

    public HttpURLConnection connectToEndpoint(ResourcesEndpointProvider endpointProvider, String method) throws IOException {
        return this.connectToEndpoint(endpointProvider.endpoint(), endpointProvider.headers(), method, endpointProvider.connectionTimeout().orElse(null));
    }
}

