/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.retries.DefaultRetryStrategy;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.retries.internal.DefaultStandardRetryStrategy;
import software.amazon.awssdk.retries.internal.circuitbreaker.TokenBucketStore;

@SdkPublicApi
@ThreadSafe
public interface StandardRetryStrategy
extends RetryStrategy {
    public static Builder builder() {
        return DefaultStandardRetryStrategy.builder().maxAttempts(3).tokenBucketStore(TokenBucketStore.builder().tokenBucketMaxCapacity(500).build()).tokenBucketExceptionCost(5).backoffStrategy(BackoffStrategy.exponentialDelay(DefaultRetryStrategy.Standard.BASE_DELAY, DefaultRetryStrategy.Standard.MAX_BACKOFF)).throttlingBackoffStrategy(BackoffStrategy.exponentialDelay(DefaultRetryStrategy.Standard.THROTTLED_BASE_DELAY, DefaultRetryStrategy.Standard.MAX_BACKOFF));
    }

    public Builder toBuilder();

    public static interface Builder
    extends RetryStrategy.Builder<Builder, StandardRetryStrategy> {
        public Builder circuitBreakerEnabled(Boolean var1);

        @Override
        public StandardRetryStrategy build();
    }
}

