/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.NotebookMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportNotebookResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ExportNotebookResponse> {
    private static final SdkField<NotebookMetadata> NOTEBOOK_METADATA_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("NotebookMetadata").getter(ExportNotebookResponse.getter(ExportNotebookResponse::notebookMetadata)).setter(ExportNotebookResponse.setter(Builder::notebookMetadata)).constructor(NotebookMetadata::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookMetadata").build()).build();
    private static final SdkField<String> PAYLOAD_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Payload").getter(ExportNotebookResponse.getter(ExportNotebookResponse::payload)).setter(ExportNotebookResponse.setter(Builder::payload)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_METADATA_FIELD, PAYLOAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportNotebookResponse.memberNameToFieldInitializer();
    private final NotebookMetadata notebookMetadata;
    private final String payload;

    private ExportNotebookResponse(BuilderImpl builder) {
        super(builder);
        this.notebookMetadata = builder.notebookMetadata;
        this.payload = builder.payload;
    }

    public final NotebookMetadata notebookMetadata() {
        return this.notebookMetadata;
    }

    public final String payload() {
        return this.payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportNotebookResponse)) {
            return false;
        }
        ExportNotebookResponse other = (ExportNotebookResponse)obj;
        return Objects.equals(this.notebookMetadata(), other.notebookMetadata()) && Objects.equals(this.payload(), other.payload());
    }

    public final String toString() {
        return ToString.builder("ExportNotebookResponse").add("NotebookMetadata", this.notebookMetadata()).add("Payload", this.payload()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookMetadata": {
                return Optional.ofNullable(clazz.cast(this.notebookMetadata()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("NotebookMetadata", NOTEBOOK_METADATA_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportNotebookResponse, T> g) {
        return obj -> g.apply((ExportNotebookResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private NotebookMetadata notebookMetadata;
        private String payload;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportNotebookResponse model) {
            super(model);
            this.notebookMetadata(model.notebookMetadata);
            this.payload(model.payload);
        }

        public final NotebookMetadata.Builder getNotebookMetadata() {
            return this.notebookMetadata != null ? this.notebookMetadata.toBuilder() : null;
        }

        public final void setNotebookMetadata(NotebookMetadata.BuilderImpl notebookMetadata) {
            this.notebookMetadata = notebookMetadata != null ? notebookMetadata.build() : null;
        }

        @Override
        public final Builder notebookMetadata(NotebookMetadata notebookMetadata) {
            this.notebookMetadata = notebookMetadata;
            return this;
        }

        public final String getPayload() {
            return this.payload;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public ExportNotebookResponse build() {
            return new ExportNotebookResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportNotebookResponse> {
        public Builder notebookMetadata(NotebookMetadata var1);

        default public Builder notebookMetadata(Consumer<NotebookMetadata.Builder> notebookMetadata) {
            return this.notebookMetadata((NotebookMetadata)NotebookMetadata.builder().applyMutation(notebookMetadata).build());
        }

        public Builder payload(String var1);
    }
}

