/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.DataCatalogSummary;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse;

public class ListDataCatalogsIterable
implements SdkIterable<ListDataCatalogsResponse> {
    private final AthenaClient client;
    private final ListDataCatalogsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataCatalogsIterable(AthenaClient client, ListDataCatalogsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataCatalogsResponseFetcher();
    }

    @Override
    public Iterator<ListDataCatalogsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataCatalogSummary> dataCatalogsSummary() {
        Function<ListDataCatalogsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataCatalogsSummary() != null) {
                return response.dataCatalogsSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataCatalogsResponseFetcher
    implements SyncPageFetcher<ListDataCatalogsResponse> {
        private ListDataCatalogsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListDataCatalogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListDataCatalogsResponse nextPage(ListDataCatalogsResponse previousPage) {
            if (previousPage == null) {
                return ListDataCatalogsIterable.this.client.listDataCatalogs(ListDataCatalogsIterable.this.firstRequest);
            }
            return ListDataCatalogsIterable.this.client.listDataCatalogs((ListDataCatalogsRequest)ListDataCatalogsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

