/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.TableMetadata;

public class ListTableMetadataIterable
implements SdkIterable<ListTableMetadataResponse> {
    private final AthenaClient client;
    private final ListTableMetadataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTableMetadataIterable(AthenaClient client, ListTableMetadataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTableMetadataResponseFetcher();
    }

    @Override
    public Iterator<ListTableMetadataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TableMetadata> tableMetadataList() {
        Function<ListTableMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableMetadataList() != null) {
                return response.tableMetadataList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListTableMetadataResponseFetcher
    implements SyncPageFetcher<ListTableMetadataResponse> {
        private ListTableMetadataResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListTableMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListTableMetadataResponse nextPage(ListTableMetadataResponse previousPage) {
            if (previousPage == null) {
                return ListTableMetadataIterable.this.client.listTableMetadata(ListTableMetadataIterable.this.firstRequest);
            }
            return ListTableMetadataIterable.this.client.listTableMetadata((ListTableMetadataRequest)ListTableMetadataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

