/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone;

import java.net.URI;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.AwsServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.datazone.auth.scheme.DataZoneAuthSchemeProvider;
import software.amazon.awssdk.services.datazone.internal.DataZoneServiceClientConfigurationBuilder;

@SdkPublicApi
public final class DataZoneServiceClientConfiguration
extends AwsServiceClientConfiguration {
    private final DataZoneAuthSchemeProvider authSchemeProvider;

    public DataZoneServiceClientConfiguration(Builder builder) {
        super(builder);
        this.authSchemeProvider = builder.authSchemeProvider();
    }

    public static Builder builder() {
        return new DataZoneServiceClientConfigurationBuilder();
    }

    public DataZoneAuthSchemeProvider authSchemeProvider() {
        return this.authSchemeProvider;
    }

    public static interface Builder
    extends AwsServiceClientConfiguration.Builder {
        @Override
        public Builder overrideConfiguration(ClientOverrideConfiguration var1);

        @Override
        public ClientOverrideConfiguration overrideConfiguration();

        @Override
        public Builder endpointOverride(URI var1);

        @Override
        public URI endpointOverride();

        @Override
        public Builder endpointProvider(EndpointProvider var1);

        @Override
        public EndpointProvider endpointProvider();

        @Override
        public Builder region(Region var1);

        @Override
        public Region region();

        @Override
        public Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> var1);

        @Override
        public IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider();

        @Override
        public Builder putAuthScheme(AuthScheme<?> var1);

        @Override
        public Map<String, AuthScheme<?>> authSchemes();

        public Builder authSchemeProvider(DataZoneAuthSchemeProvider var1);

        public DataZoneAuthSchemeProvider authSchemeProvider();

        @Override
        public DataZoneServiceClientConfiguration build();
    }
}

