/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.Permissions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetPermission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetPermission> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("assetId").getter(AssetPermission.getter(AssetPermission::assetId)).setter(AssetPermission.setter(Builder::assetId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();
    private static final SdkField<Permissions> PERMISSIONS_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("permissions").getter(AssetPermission.getter(AssetPermission::permissions)).setter(AssetPermission.setter(Builder::permissions)).constructor(Permissions::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetPermission.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final Permissions permissions;

    private AssetPermission(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.permissions = builder.permissions;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final Permissions permissions() {
        return this.permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPermission)) {
            return false;
        }
        AssetPermission other = (AssetPermission)obj;
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.permissions(), other.permissions());
    }

    public final String toString() {
        return ToString.builder("AssetPermission").add("AssetId", this.assetId()).add("Permissions", this.permissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetPermission, T> g) {
        return obj -> g.apply((AssetPermission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private Permissions permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPermission model) {
            this.assetId(model.assetId);
            this.permissions(model.permissions);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final Permissions.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(Permissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(Permissions permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public AssetPermission build() {
            return new AssetPermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetPermission> {
        public Builder assetId(String var1);

        public Builder permissions(Permissions var1);

        default public Builder permissions(Consumer<Permissions.Builder> permissions) {
            return this.permissions((Permissions)Permissions.builder().applyMutation(permissions).build());
        }
    }
}

