/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.FilterIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetScope> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("assetId").getter(AssetScope.getter(AssetScope::assetId)).setter(AssetScope.setter(Builder::assetId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("errorMessage").getter(AssetScope.getter(AssetScope::errorMessage)).setter(AssetScope.setter(Builder::errorMessage)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();
    private static final SdkField<List<String>> FILTER_IDS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("filterIds").getter(AssetScope.getter(AssetScope::filterIds)).setter(AssetScope.setter(Builder::filterIds)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("status").getter(AssetScope.getter(AssetScope::status)).setter(AssetScope.setter(Builder::status)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ERROR_MESSAGE_FIELD, FILTER_IDS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetScope.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final String errorMessage;
    private final List<String> filterIds;
    private final String status;

    private AssetScope(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.errorMessage = builder.errorMessage;
        this.filterIds = builder.filterIds;
        this.status = builder.status;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final boolean hasFilterIds() {
        return this.filterIds != null && !(this.filterIds instanceof SdkAutoConstructList);
    }

    public final List<String> filterIds() {
        return this.filterIds;
    }

    public final String status() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterIds() ? this.filterIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetScope)) {
            return false;
        }
        AssetScope other = (AssetScope)obj;
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasFilterIds() == other.hasFilterIds() && Objects.equals(this.filterIds(), other.filterIds()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder("AssetScope").add("AssetId", this.assetId()).add("ErrorMessage", this.errorMessage()).add("FilterIds", this.hasFilterIds() ? this.filterIds() : null).add("Status", this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "filterIds": {
                return Optional.ofNullable(clazz.cast(this.filterIds()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("filterIds", FILTER_IDS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetScope, T> g) {
        return obj -> g.apply((AssetScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private String errorMessage;
        private List<String> filterIds = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetScope model) {
            this.assetId(model.assetId);
            this.errorMessage(model.errorMessage);
            this.filterIds(model.filterIds);
            this.status(model.status);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Collection<String> getFilterIds() {
            if (this.filterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterIds;
        }

        public final void setFilterIds(Collection<String> filterIds) {
            this.filterIds = FilterIdsCopier.copy(filterIds);
        }

        @Override
        public final Builder filterIds(Collection<String> filterIds) {
            this.filterIds = FilterIdsCopier.copy(filterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterIds(String ... filterIds) {
            this.filterIds(Arrays.asList(filterIds));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AssetScope build() {
            return new AssetScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetScope> {
        public Builder assetId(String var1);

        public Builder errorMessage(String var1);

        public Builder filterIds(Collection<String> var1);

        public Builder filterIds(String ... var1);

        public Builder status(String var1);
    }
}

