/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.ConfigurableActionParameter;
import software.amazon.awssdk.services.datazone.model.ConfigurableActionParameterListCopier;
import software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurableEnvironmentAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurableEnvironmentAction> {
    private static final SdkField<String> AUTH_FIELD = SdkField.builder(MarshallingType.STRING).memberName("auth").getter(ConfigurableEnvironmentAction.getter(ConfigurableEnvironmentAction::authAsString)).setter(ConfigurableEnvironmentAction.setter(Builder::auth)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auth").build()).build();
    private static final SdkField<List<ConfigurableActionParameter>> PARAMETERS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("parameters").getter(ConfigurableEnvironmentAction.getter(ConfigurableEnvironmentAction::parameters)).setter(ConfigurableEnvironmentAction.setter(Builder::parameters)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(ConfigurableActionParameter::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("type").getter(ConfigurableEnvironmentAction.getter(ConfigurableEnvironmentAction::type)).setter(ConfigurableEnvironmentAction.setter(Builder::type)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_FIELD, PARAMETERS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurableEnvironmentAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String auth;
    private final List<ConfigurableActionParameter> parameters;
    private final String type;

    private ConfigurableEnvironmentAction(BuilderImpl builder) {
        this.auth = builder.auth;
        this.parameters = builder.parameters;
        this.type = builder.type;
    }

    public final ConfigurableActionTypeAuthorization auth() {
        return ConfigurableActionTypeAuthorization.fromValue(this.auth);
    }

    public final String authAsString() {
        return this.auth;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<ConfigurableActionParameter> parameters() {
        return this.parameters;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableEnvironmentAction)) {
            return false;
        }
        ConfigurableEnvironmentAction other = (ConfigurableEnvironmentAction)obj;
        return Objects.equals(this.authAsString(), other.authAsString()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder("ConfigurableEnvironmentAction").add("Auth", this.authAsString()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Type", this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "auth": {
                return Optional.ofNullable(clazz.cast(this.authAsString()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("auth", AUTH_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurableEnvironmentAction, T> g) {
        return obj -> g.apply((ConfigurableEnvironmentAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String auth;
        private List<ConfigurableActionParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurableEnvironmentAction model) {
            this.auth(model.auth);
            this.parameters(model.parameters);
            this.type(model.type);
        }

        public final String getAuth() {
            return this.auth;
        }

        public final void setAuth(String auth) {
            this.auth = auth;
        }

        @Override
        public final Builder auth(String auth) {
            this.auth = auth;
            return this;
        }

        @Override
        public final Builder auth(ConfigurableActionTypeAuthorization auth) {
            this.auth(auth == null ? null : auth.toString());
            return this;
        }

        public final List<ConfigurableActionParameter.Builder> getParameters() {
            List<ConfigurableActionParameter.Builder> result = ConfigurableActionParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ConfigurableActionParameter.BuilderImpl> parameters) {
            this.parameters = ConfigurableActionParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ConfigurableActionParameter> parameters) {
            this.parameters = ConfigurableActionParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ConfigurableActionParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ConfigurableActionParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (ConfigurableActionParameter)((ConfigurableActionParameter.Builder)ConfigurableActionParameter.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public ConfigurableEnvironmentAction build() {
            return new ConfigurableEnvironmentAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurableEnvironmentAction> {
        public Builder auth(String var1);

        public Builder auth(ConfigurableActionTypeAuthorization var1);

        public Builder parameters(Collection<ConfigurableActionParameter> var1);

        public Builder parameters(ConfigurableActionParameter ... var1);

        public Builder parameters(Consumer<ConfigurableActionParameter.Builder> ... var1);

        public Builder type(String var1);
    }
}

