/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.DomainVersion;
import software.amazon.awssdk.services.datazone.model.SingleSignOn;
import software.amazon.awssdk.services.datazone.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateDomainRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("clientToken").getter(CreateDomainRequest.getter(CreateDomainRequest::clientToken)).setter(CreateDomainRequest.setter(Builder::clientToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(CreateDomainRequest.getter(CreateDomainRequest::description)).setter(CreateDomainRequest.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_EXECUTION_ROLE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainExecutionRole").getter(CreateDomainRequest.getter(CreateDomainRequest::domainExecutionRole)).setter(CreateDomainRequest.setter(Builder::domainExecutionRole)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainExecutionRole").build()).build();
    private static final SdkField<String> DOMAIN_VERSION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainVersion").getter(CreateDomainRequest.getter(CreateDomainRequest::domainVersionAsString)).setter(CreateDomainRequest.setter(Builder::domainVersion)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVersion").build()).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("kmsKeyIdentifier").getter(CreateDomainRequest.getter(CreateDomainRequest::kmsKeyIdentifier)).setter(CreateDomainRequest.setter(Builder::kmsKeyIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(CreateDomainRequest.getter(CreateDomainRequest::name)).setter(CreateDomainRequest.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("serviceRole").getter(CreateDomainRequest.getter(CreateDomainRequest::serviceRole)).setter(CreateDomainRequest.setter(Builder::serviceRole)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();
    private static final SdkField<SingleSignOn> SINGLE_SIGN_ON_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("singleSignOn").getter(CreateDomainRequest.getter(CreateDomainRequest::singleSignOn)).setter(CreateDomainRequest.setter(Builder::singleSignOn)).constructor(SingleSignOn::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("singleSignOn").build()).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder(MarshallingType.MAP).memberName("tags").getter(CreateDomainRequest.getter(CreateDomainRequest::tags)).setter(CreateDomainRequest.setter(Builder::tags)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DOMAIN_EXECUTION_ROLE_FIELD, DOMAIN_VERSION_FIELD, KMS_KEY_IDENTIFIER_FIELD, NAME_FIELD, SERVICE_ROLE_FIELD, SINGLE_SIGN_ON_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDomainRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String description;
    private final String domainExecutionRole;
    private final String domainVersion;
    private final String kmsKeyIdentifier;
    private final String name;
    private final String serviceRole;
    private final SingleSignOn singleSignOn;
    private final Map<String, String> tags;

    private CreateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainExecutionRole = builder.domainExecutionRole;
        this.domainVersion = builder.domainVersion;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.name = builder.name;
        this.serviceRole = builder.serviceRole;
        this.singleSignOn = builder.singleSignOn;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String domainExecutionRole() {
        return this.domainExecutionRole;
    }

    public final DomainVersion domainVersion() {
        return DomainVersion.fromValue(this.domainVersion);
    }

    public final String domainVersionAsString() {
        return this.domainVersion;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final SingleSignOn singleSignOn() {
        return this.singleSignOn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest)obj;
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainExecutionRole(), other.domainExecutionRole()) && Objects.equals(this.domainVersionAsString(), other.domainVersionAsString()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.singleSignOn(), other.singleSignOn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder("CreateDomainRequest").add("ClientToken", this.clientToken()).add("Description", this.description()).add("DomainExecutionRole", this.domainExecutionRole()).add("DomainVersion", this.domainVersionAsString()).add("KmsKeyIdentifier", this.kmsKeyIdentifier()).add("Name", this.name()).add("ServiceRole", this.serviceRole()).add("SingleSignOn", this.singleSignOn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.domainExecutionRole()));
            }
            case "domainVersion": {
                return Optional.ofNullable(clazz.cast(this.domainVersionAsString()));
            }
            case "kmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "singleSignOn": {
                return Optional.ofNullable(clazz.cast(this.singleSignOn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainExecutionRole", DOMAIN_EXECUTION_ROLE_FIELD);
        map.put("domainVersion", DOMAIN_VERSION_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("serviceRole", SERVICE_ROLE_FIELD);
        map.put("singleSignOn", SINGLE_SIGN_ON_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainRequest, T> g) {
        return obj -> g.apply((CreateDomainRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String domainExecutionRole;
        private String domainVersion;
        private String kmsKeyIdentifier;
        private String name;
        private String serviceRole;
        private SingleSignOn singleSignOn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.domainExecutionRole(model.domainExecutionRole);
            this.domainVersion(model.domainVersion);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.name(model.name);
            this.serviceRole(model.serviceRole);
            this.singleSignOn(model.singleSignOn);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainExecutionRole() {
            return this.domainExecutionRole;
        }

        public final void setDomainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
        }

        @Override
        public final Builder domainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
            return this;
        }

        public final String getDomainVersion() {
            return this.domainVersion;
        }

        public final void setDomainVersion(String domainVersion) {
            this.domainVersion = domainVersion;
        }

        @Override
        public final Builder domainVersion(String domainVersion) {
            this.domainVersion = domainVersion;
            return this;
        }

        @Override
        public final Builder domainVersion(DomainVersion domainVersion) {
            this.domainVersion(domainVersion == null ? null : domainVersion.toString());
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final SingleSignOn.Builder getSingleSignOn() {
            return this.singleSignOn != null ? this.singleSignOn.toBuilder() : null;
        }

        public final void setSingleSignOn(SingleSignOn.BuilderImpl singleSignOn) {
            this.singleSignOn = singleSignOn != null ? singleSignOn.build() : null;
        }

        @Override
        public final Builder singleSignOn(SingleSignOn singleSignOn) {
            this.singleSignOn = singleSignOn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainRequest build() {
            return new CreateDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder domainExecutionRole(String var1);

        public Builder domainVersion(String var1);

        public Builder domainVersion(DomainVersion var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder name(String var1);

        public Builder serviceRole(String var1);

        public Builder singleSignOn(SingleSignOn var1);

        default public Builder singleSignOn(Consumer<SingleSignOn.Builder> singleSignOn) {
            return this.singleSignOn((SingleSignOn)SingleSignOn.builder().applyMutation(singleSignOn).build());
        }

        public Builder tags(Map<String, String> var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

