/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.GlossaryStatus;
import software.amazon.awssdk.services.datazone.model.GlossaryUsageRestriction;
import software.amazon.awssdk.services.datazone.model.GlossaryUsageRestrictionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGlossaryResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, CreateGlossaryResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(CreateGlossaryResponse.getter(CreateGlossaryResponse::description)).setter(CreateGlossaryResponse.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(CreateGlossaryResponse.getter(CreateGlossaryResponse::domainId)).setter(CreateGlossaryResponse.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("id").getter(CreateGlossaryResponse.getter(CreateGlossaryResponse::id)).setter(CreateGlossaryResponse.setter(Builder::id)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(CreateGlossaryResponse.getter(CreateGlossaryResponse::name)).setter(CreateGlossaryResponse.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("owningProjectId").getter(CreateGlossaryResponse.getter(CreateGlossaryResponse::owningProjectId)).setter(CreateGlossaryResponse.setter(Builder::owningProjectId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("status").getter(CreateGlossaryResponse.getter(CreateGlossaryResponse::statusAsString)).setter(CreateGlossaryResponse.setter(Builder::status)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();
    private static final SdkField<List<String>> USAGE_RESTRICTIONS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("usageRestrictions").getter(CreateGlossaryResponse.getter(CreateGlossaryResponse::usageRestrictionsAsStrings)).setter(CreateGlossaryResponse.setter(Builder::usageRestrictionsWithStrings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageRestrictions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_ID_FIELD, ID_FIELD, NAME_FIELD, OWNING_PROJECT_ID_FIELD, STATUS_FIELD, USAGE_RESTRICTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGlossaryResponse.memberNameToFieldInitializer();
    private final String description;
    private final String domainId;
    private final String id;
    private final String name;
    private final String owningProjectId;
    private final String status;
    private final List<String> usageRestrictions;

    private CreateGlossaryResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
        this.status = builder.status;
        this.usageRestrictions = builder.usageRestrictions;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public final GlossaryStatus status() {
        return GlossaryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final List<GlossaryUsageRestriction> usageRestrictions() {
        return GlossaryUsageRestrictionsCopier.copyStringToEnum(this.usageRestrictions);
    }

    public final boolean hasUsageRestrictions() {
        return this.usageRestrictions != null && !(this.usageRestrictions instanceof SdkAutoConstructList);
    }

    public final List<String> usageRestrictionsAsStrings() {
        return this.usageRestrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsageRestrictions() ? this.usageRestrictionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlossaryResponse)) {
            return false;
        }
        CreateGlossaryResponse other = (CreateGlossaryResponse)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectId(), other.owningProjectId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasUsageRestrictions() == other.hasUsageRestrictions() && Objects.equals(this.usageRestrictionsAsStrings(), other.usageRestrictionsAsStrings());
    }

    public final String toString() {
        return ToString.builder("CreateGlossaryResponse").add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", this.domainId()).add("Id", this.id()).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("OwningProjectId", this.owningProjectId()).add("Status", this.statusAsString()).add("UsageRestrictions", this.hasUsageRestrictions() ? this.usageRestrictionsAsStrings() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "usageRestrictions": {
                return Optional.ofNullable(clazz.cast(this.usageRestrictionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("usageRestrictions", USAGE_RESTRICTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlossaryResponse, T> g) {
        return obj -> g.apply((CreateGlossaryResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String description;
        private String domainId;
        private String id;
        private String name;
        private String owningProjectId;
        private String status;
        private List<String> usageRestrictions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlossaryResponse model) {
            super(model);
            this.description(model.description);
            this.domainId(model.domainId);
            this.id(model.id);
            this.name(model.name);
            this.owningProjectId(model.owningProjectId);
            this.status(model.status);
            this.usageRestrictionsWithStrings(model.usageRestrictions);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GlossaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getUsageRestrictions() {
            if (this.usageRestrictions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.usageRestrictions;
        }

        public final void setUsageRestrictions(Collection<String> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copy(usageRestrictions);
        }

        @Override
        public final Builder usageRestrictionsWithStrings(Collection<String> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copy(usageRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRestrictionsWithStrings(String ... usageRestrictions) {
            this.usageRestrictionsWithStrings(Arrays.asList(usageRestrictions));
            return this;
        }

        @Override
        public final Builder usageRestrictions(Collection<GlossaryUsageRestriction> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copyEnumToString(usageRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRestrictions(GlossaryUsageRestriction ... usageRestrictions) {
            this.usageRestrictions(Arrays.asList(usageRestrictions));
            return this;
        }

        @Override
        public CreateGlossaryResponse build() {
            return new CreateGlossaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGlossaryResponse> {
        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder owningProjectId(String var1);

        public Builder status(String var1);

        public Builder status(GlossaryStatus var1);

        public Builder usageRestrictionsWithStrings(Collection<String> var1);

        public Builder usageRestrictionsWithStrings(String ... var1);

        public Builder usageRestrictions(Collection<GlossaryUsageRestriction> var1);

        public Builder usageRestrictions(GlossaryUsageRestriction ... var1);
    }
}

